/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.annotation.test;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.iterable.Extractor;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.annotation.model.Author;
import org.infinispan.client.hotrod.annotation.model.Poem;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.annotation.test.PoemTest")
public class PoemTest
extends SingleHotRodServerTest {
    private static final Extractor<Object[], Object> FIRST_ELEMENT_OF_THE_ARRAY = item -> item[0];

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("poem.Poem");
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager();
        manager.defineConfiguration("poems", builder.build());
        return manager;
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return Poem.PoemSchema.INSTANCE;
    }

    @Test
    public void testSearches() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache("poems");
        remoteCache.put((Object)1, (Object)new Poem(new Author("Edgar Allen Poe"), "The Raven", 1845));
        remoteCache.put((Object)2, (Object)new Poem(new Author("Emily Dickinson"), "Because I could not stop for Death", 1890));
        remoteCache.put((Object)3, (Object)new Poem(new Author("Emma Lazarus"), "The New Colossus", 1883));
        remoteCache.put((Object)4, (Object)new Poem(new Author(null), "Alla Sera", null));
        QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)remoteCache);
        Query query = queryFactory.create("select p.author.name from poem.Poem p order by p.author.name");
        List poems = query.execute().list();
        Assertions.assertThat((List)poems).extracting(FIRST_ELEMENT_OF_THE_ARRAY).containsExactly(new Object[]{"Edgar Allen Poe", "Emily Dickinson", "Emma Lazarus", null});
        Assertions.assertThat((List)queryFactory.create("from poem.Poem p where p.year < 1885 order by p.author.name").execute().list()).extracting("year").containsExactly(new Object[]{1845, 1883, 1803});
        query = queryFactory.create("select p.description from poem.Poem p where p.description : 'The' order by p.year");
        poems = query.execute().list();
        Assertions.assertThat((List)poems).extracting(FIRST_ELEMENT_OF_THE_ARRAY).containsExactly(new Object[]{"The Raven", "The New Colossus"});
        Assertions.assertThat((List)queryFactory.create("from poem.Poem p where p.description : 'the'").execute().list()).isEmpty();
        query = queryFactory.create("select p.year from poem.Poem p where p.author.name = 'eMMA lazaRUS'");
        poems = query.execute().list();
        Assertions.assertThat((List)poems).extracting(FIRST_ELEMENT_OF_THE_ARRAY).containsExactly(new Object[]{1883});
    }
}

