/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.event.FailoverEventLogListener;
import org.infinispan.client.hotrod.event.StickyServerLoadBalancingStrategy;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.CacheContainer;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledTimeService;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientClusterFailoverEventsTest")
public class ClientClusterFailoverEventsTest
extends MultiHotRodServersTest {
    protected ControlledTimeService ts0;
    protected ControlledTimeService ts1;

    protected void createCacheManagers() throws Throwable {
    }

    private void injectTimeServices() {
        this.ts0 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.server(0).getCacheManager(), TimeService.class, (Object)this.ts0, (boolean)true);
        this.ts1 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.server(1).getCacheManager(), TimeService.class, (Object)this.ts1, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventReplayWithAndWithoutStateAfterFailover() {
        org.infinispan.configuration.cache.ConfigurationBuilder base = ClientClusterFailoverEventsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)base);
        this.createHotRodServers(2, builder);
        this.injectTimeServices();
        try {
            Integer key00 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
            Integer key10 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
            Integer key11 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
            Integer key21 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
            Integer key31 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
            Integer key41 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
            ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
            HotRodServer server = this.server(0);
            clientBuilder.addServers(server.getHost() + ":" + server.getPort());
            clientBuilder.balancingStrategy(StickyServerLoadBalancingStrategy.class);
            RemoteCacheManager newClient = new RemoteCacheManager(clientBuilder.build());
            try {
                RemoteCache c = newClient.getCache();
                WithStateEventLogListener<Integer> statefulListener = new WithStateEventLogListener<Integer>(c);
                EventLogListener<Integer> statelessListener = new EventLogListener<Integer>(c);
                FailoverEventLogListener<Integer> failoverListener = new FailoverEventLogListener<Integer>(c);
                c.addClientListener(statelessListener);
                c.addClientListener(statefulListener);
                c.addClientListener(failoverListener);
                c.put((Object)key00, (Object)"zero");
                statefulListener.expectOnlyCreatedEvent(key00);
                statelessListener.expectOnlyCreatedEvent(key00);
                failoverListener.expectOnlyCreatedEvent(key00);
                c.put((Object)key10, (Object)"one", 1000L, TimeUnit.MILLISECONDS);
                statefulListener.expectOnlyCreatedEvent(key10);
                statelessListener.expectOnlyCreatedEvent(key10);
                failoverListener.expectOnlyCreatedEvent(key10);
                c.put((Object)key11, (Object)"two");
                statefulListener.expectOnlyCreatedEvent(key11);
                statelessListener.expectOnlyCreatedEvent(key11);
                failoverListener.expectOnlyCreatedEvent(key11);
                c.put((Object)key41, (Object)"three", 1000L, TimeUnit.MILLISECONDS);
                statefulListener.expectOnlyCreatedEvent(key41);
                statelessListener.expectOnlyCreatedEvent(key41);
                failoverListener.expectOnlyCreatedEvent(key41);
                this.ts0.advance(1001L);
                this.ts1.advance(1001L);
                HotRodClientTestingUtil.findServerAndKill(newClient, this.servers, this.cacheManagers);
                statelessListener.expectNoEvents();
                statefulListener.expectFailoverEvent();
                failoverListener.expectFailoverEvent();
                statelessListener.expectNoEvents();
                failoverListener.expectNoEvents();
                statefulListener.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, key00, key11);
                statefulListener.expectNoEvents();
                c.put((Object)key31, (Object)"five");
                statefulListener.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, key31);
                c.remove((Object)key11);
                c.remove((Object)key21);
                c.remove((Object)key31);
            }
            finally {
                HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)newClient);
            }
        }
        finally {
            this.destroy();
        }
    }

    @ClientListener(includeCurrentState=true)
    public static class WithStateEventLogListener<K>
    extends FailoverEventLogListener<K> {
        public WithStateEventLogListener(RemoteCache<K, ?> remote) {
            super(remote);
        }
    }
}

