/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.IOException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.ClientEventSCI;
import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientCustomEventsTest")
public class ClientCustomEventsTest
extends SingleHotRodServerTest {
    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(this.cacheManager, builder);
        server.addCacheEventConverterFactory("static-converter-factory", new CustomEventLogListener.StaticConverterFactory());
        server.addCacheEventConverterFactory("dynamic-converter-factory", new CustomEventLogListener.DynamicConverterFactory());
        server.addCacheEventConverterFactory("raw-static-converter-factory", (CacheEventConverterFactory)new CustomEventLogListener.RawStaticConverterFactory());
        server.addCacheEventConverterFactory("simple-converter-factory", new CustomEventLogListener.SimpleConverterFactory());
        return server;
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return ClientEventSCI.INSTANCE;
    }

    public void testCustomEvents() {
        CustomEventLogListener.StaticCustomEventLogListener l = new CustomEventLogListener.StaticCustomEventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(1, "one", 0));
            remote.put((Object)1, (Object)"newone");
            l.expectModifiedEvent(new CustomEventLogListener.CustomEvent<Integer>(1, "newone", 0));
            remote.remove((Object)1);
            l.expectRemovedEvent(new CustomEventLogListener.CustomEvent<Integer>(1, null, 0));
        });
    }

    public void testCustomEvents2() {
        CustomEventLogListener.SimpleListener l = new CustomEventLogListener.SimpleListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)"1", (Object)"one");
            l.expectCreatedEvent("one");
        });
    }

    public void testTimeOrderedEvents() {
        CustomEventLogListener.StaticCustomEventLogListener l = new CustomEventLogListener.StaticCustomEventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            remote.replace((Object)1, (Object)"newone");
            remote.replace((Object)1, (Object)"newnewone");
            remote.replace((Object)1, (Object)"newnewnewone");
            remote.replace((Object)1, (Object)"newnewnewnewone");
            remote.replace((Object)1, (Object)"newnewnewnewnewone");
            l.expectOrderedEventQueue(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        });
    }

    @Test(expectedExceptions={HotRodClientException.class})
    public void testNonExistingConverterFactoryCustomEvents() {
        NonExistingConverterFactoryListener l = new NonExistingConverterFactoryListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {});
    }

    public void testNoConverterFactoryCustomEvents() {
        NoConverterFactoryListener l = new NoConverterFactoryListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            l.expectNoEvents();
        });
    }

    public void testParameterBasedConversion() {
        CustomEventLogListener.DynamicCustomEventLogListener l = new CustomEventLogListener.DynamicCustomEventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, null, new Object[]{2}, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(1, "one", 0));
            remote.put((Object)2, (Object)"two");
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(2, null, 0));
        });
    }

    public void testConvertedEventsReplay() {
        RemoteCache cache = this.remoteCacheManager.getCache();
        cache.put((Object)1, (Object)"one");
        CustomEventLogListener.StaticCustomEventLogWithStateListener staticEventListener = new CustomEventLogListener.StaticCustomEventLogWithStateListener(cache);
        HotRodClientTestingUtil.withClientListener(staticEventListener, remote -> staticEventListener.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(1, "one", 0)));
        CustomEventLogListener.DynamicCustomEventWithStateLogListener dynamicEventListener = new CustomEventLogListener.DynamicCustomEventWithStateLogListener(cache);
        HotRodClientTestingUtil.withClientListener(dynamicEventListener, null, new Object[]{2}, remote -> {
            dynamicEventListener.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(1, "one", 0));
            cache.put((Object)2, (Object)"two");
            dynamicEventListener.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(2, null, 0));
        });
    }

    public void testConvertedNoEventsReplay() {
        RemoteCache cache = this.remoteCacheManager.getCache();
        CustomEventLogListener.StaticCustomEventLogListener staticEventListener = new CustomEventLogListener.StaticCustomEventLogListener(cache);
        cache.put((Object)1, (Object)"one");
        HotRodClientTestingUtil.withClientListener(staticEventListener, remote -> staticEventListener.expectNoEvents());
        CustomEventLogListener.DynamicCustomEventLogListener dynamicEventListener = new CustomEventLogListener.DynamicCustomEventLogListener(cache);
        cache.put((Object)2, (Object)"two");
        HotRodClientTestingUtil.withClientListener(dynamicEventListener, null, new Object[]{2}, remote -> staticEventListener.expectNoEvents());
    }

    public void testRawCustomEvents() {
        CustomEventLogListener.RawStaticCustomEventLogListener eventListener = new CustomEventLogListener.RawStaticCustomEventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(eventListener, remote -> {
            eventListener.expectNoEvents();
            Marshaller marshaller = remote.getRemoteCacheContainer().getMarshaller();
            Integer key = 1;
            String value = "one";
            try {
                byte[] keyBytes = marshaller.objectToByteBuffer((Object)key);
                byte[] valBytes = marshaller.objectToByteBuffer((Object)value);
                remote.put((Object)key, (Object)value);
                eventListener.expectCreatedEvent(CustomEventLogListener.concat(keyBytes, valBytes));
                value = "newone";
                valBytes = marshaller.objectToByteBuffer((Object)value);
                remote.put((Object)key, (Object)value);
                eventListener.expectModifiedEvent(CustomEventLogListener.concat(keyBytes, valBytes));
                remote.remove((Object)key);
                eventListener.expectRemovedEvent(keyBytes);
            }
            catch (IOException | InterruptedException e) {
                AssertJUnit.fail((String)e.getMessage());
            }
        });
    }

    @ClientListener
    public static class NoConverterFactoryListener<K>
    extends CustomEventLogListener<K, Object> {
        public NoConverterFactoryListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }

    @ClientListener(converterFactoryName="non-existing-test-converter-factory")
    public static class NonExistingConverterFactoryListener<K>
    extends CustomEventLogListener<K, Object> {
        public NonExistingConverterFactoryListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }
}

