/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.RemoteCacheSupplier;
import org.infinispan.filter.NamedFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.AbstractCacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;

@ClientListener(converterFactoryName="test-converter-factory")
public abstract class CustomEventLogListener<K, E>
implements RemoteCacheSupplier<K> {
    BlockingQueue<E> createdCustomEvents = new ArrayBlockingQueue(128);
    BlockingQueue<E> modifiedCustomEvents = new ArrayBlockingQueue(128);
    BlockingQueue<E> removedCustomEvents = new ArrayBlockingQueue(128);
    BlockingQueue<E> expiredCustomEvents = new ArrayBlockingQueue(128);
    private final RemoteCache<K, ?> remote;

    protected CustomEventLogListener(RemoteCache<K, ?> remote) {
        this.remote = remote;
    }

    @Override
    public <V> RemoteCache<K, V> get() {
        return this.remote;
    }

    public E pollEvent(ClientEvent.Type type) {
        try {
            E event = this.queue(type).poll(10L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull(event);
            return event;
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected BlockingQueue<E> queue(ClientEvent.Type type) {
        switch (type) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                return this.createdCustomEvents;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                return this.modifiedCustomEvents;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                return this.removedCustomEvents;
            }
            case CLIENT_CACHE_ENTRY_EXPIRED: {
                return this.expiredCustomEvents;
            }
        }
        throw new IllegalArgumentException("Unknown event type: " + type);
    }

    public void expectNoEvents(ClientEvent.Type type) {
        AssertJUnit.assertEquals((int)0, (int)this.queue(type).size());
    }

    public void expectNoEvents() {
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED);
    }

    public void expectSingleCustomEvent(ClientEvent.Type type, E expected) {
        E event = this.pollEvent(type);
        TestingUtil.assertAnyEquals(expected, event);
    }

    public void expectCreatedEvent(E expected) {
        this.expectSingleCustomEvent(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, expected);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED);
    }

    public void expectModifiedEvent(E expected) {
        this.expectSingleCustomEvent(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED, expected);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED);
    }

    public void expectRemovedEvent(E expected) {
        this.expectSingleCustomEvent(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED, expected);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED);
    }

    public void expectExpiredEvent(E expected) {
        this.expectSingleCustomEvent(ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED, expected);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    @ClientCacheEntryCreated
    public void handleCustomCreatedEvent(ClientCacheEntryCustomEvent<E> e) {
        AssertJUnit.assertEquals((Object)ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, (Object)e.getType());
        this.createdCustomEvents.add(e.getEventData());
    }

    @ClientCacheEntryModified
    public void handleCustomModifiedEvent(ClientCacheEntryCustomEvent<E> e) {
        AssertJUnit.assertEquals((Object)ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED, (Object)e.getType());
        this.modifiedCustomEvents.add(e.getEventData());
    }

    @ClientCacheEntryRemoved
    public void handleCustomRemovedEvent(ClientCacheEntryCustomEvent<E> e) {
        AssertJUnit.assertEquals((Object)ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED, (Object)e.getType());
        this.removedCustomEvents.add(e.getEventData());
    }

    @ClientCacheEntryExpired
    public void handleCustomExpiredEvent(ClientCacheEntryCustomEvent<E> e) {
        AssertJUnit.assertEquals((Object)ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED, (Object)e.getType());
        this.expiredCustomEvents.add(e.getEventData());
    }

    static byte[] concat(byte[] a, byte[] b) {
        int aLen = a.length;
        int bLen = b.length;
        byte[] ret = new byte[aLen + bLen];
        System.arraycopy(a, 0, ret, 0, aLen);
        System.arraycopy(b, 0, ret, aLen, bLen);
        return ret;
    }

    @ClientListener(filterFactoryName="filter-converter-factory", converterFactoryName="filter-converter-factory")
    public static class FilterCustomEventLogListener<K>
    extends CustomEventLogListener<K, CustomEvent> {
        public FilterCustomEventLogListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }

    @NamedFactory(name="filter-converter-factory")
    public static class FilterConverterFactory
    implements CacheEventFilterConverterFactory {
        public CacheEventFilterConverter<Integer, String, CustomEvent> getFilterConverter(Object[] params) {
            return new FilterConverter(params);
        }

        static class FilterConverter
        extends AbstractCacheEventFilterConverter<Integer, String, CustomEvent> {
            private final Object[] params;
            @ProtoField(number=1, defaultValue="0")
            int count;

            FilterConverter(Object[] params) {
                this.params = params;
                this.count = 0;
            }

            @ProtoFactory
            FilterConverter(List<WrappedMessage> wrappedParams, int count) {
                this.params = wrappedParams == null ? null : wrappedParams.stream().map(WrappedMessage::getValue).toArray();
                this.count = count;
            }

            @ProtoField(number=2, collectionImplementation=ArrayList.class)
            List<WrappedMessage> getWrappedParams() {
                return Arrays.stream(this.params).map(WrappedMessage::new).collect(Collectors.toList());
            }

            public CustomEvent filterAndConvert(Integer key, String oldValue, Metadata oldMetadata, String newValue, Metadata newMetadata, EventType eventType) {
                ++this.count;
                if (this.params[0].equals(key)) {
                    return new CustomEvent<Integer>(key, null, this.count);
                }
                return new CustomEvent<Integer>(key, newValue, this.count);
            }
        }
    }

    @NamedFactory(name="raw-static-converter-factory")
    public static class RawStaticConverterFactory
    implements CacheEventConverterFactory {
        public CacheEventConverter<byte[], byte[], byte[]> getConverter(Object[] params) {
            return new RawStaticConverter();
        }

        @ProtoName(value="RawStaticConverter")
        static class RawStaticConverter
        implements CacheEventConverter<byte[], byte[], byte[]>,
        Serializable {
            RawStaticConverter() {
            }

            public byte[] convert(byte[] key, byte[] previousValue, Metadata previousMetadata, byte[] value, Metadata metadata, EventType eventType) {
                return value != null ? CustomEventLogListener.concat(key, value) : key;
            }
        }
    }

    @NamedFactory(name="dynamic-converter-factory")
    public static class DynamicConverterFactory<K>
    implements CacheEventConverterFactory {
        public CacheEventConverter<K, String, CustomEvent> getConverter(Object[] params) {
            return new DynamicConverter(params);
        }

        static class DynamicConverter<K>
        implements CacheEventConverter<K, String, CustomEvent>,
        Serializable {
            private final Object[] params;

            public DynamicConverter(Object[] params) {
                this.params = params;
            }

            @ProtoFactory
            DynamicConverter(ArrayList<WrappedMessage> wrappedParams) {
                this.params = wrappedParams == null ? null : wrappedParams.stream().map(WrappedMessage::getValue).toArray();
            }

            @ProtoField(number=1, collectionImplementation=ArrayList.class)
            List<WrappedMessage> getWrappedParams() {
                return Arrays.stream(this.params).map(WrappedMessage::new).collect(Collectors.toList());
            }

            public CustomEvent convert(K key, String previousValue, Metadata previousMetadata, String value, Metadata metadata, EventType eventType) {
                if (this.params[0].equals(key)) {
                    return new CustomEvent<K>(key, null, 0);
                }
                return new CustomEvent<K>(key, value, 0);
            }
        }
    }

    @NamedFactory(name="static-converter-factory")
    public static class StaticConverterFactory<K>
    implements CacheEventConverterFactory {
        public CacheEventConverter<K, String, CustomEvent> getConverter(Object[] params) {
            return new StaticConverter();
        }

        @ProtoName(value="StaticConverter")
        static class StaticConverter<K>
        implements CacheEventConverter<K, String, CustomEvent>,
        Serializable {
            StaticConverter() {
            }

            public CustomEvent convert(K key, String previousValue, Metadata previousMetadata, String value, Metadata metadata, EventType eventType) {
                return new CustomEvent<K>(key, value, 0);
            }
        }
    }

    @NamedFactory(name="simple-converter-factory")
    static class SimpleConverterFactory<K>
    implements CacheEventConverterFactory {
        SimpleConverterFactory() {
        }

        public CacheEventConverter<String, String, CustomEvent> getConverter(Object[] params) {
            return new SimpleConverter<String>();
        }

        @ProtoName(value="SimpleConverter")
        static class SimpleConverter<K>
        implements CacheEventConverter<K, String, String>,
        Serializable {
            SimpleConverter() {
            }

            public String convert(K key, String oldValue, Metadata oldMetadata, String newValue, Metadata newMetadata, EventType eventType) {
                if (newValue != null) {
                    return newValue;
                }
                return oldValue;
            }
        }
    }

    @ClientListener(converterFactoryName="simple-converter-factory")
    public static class SimpleListener<K>
    extends CustomEventLogListener<K, String> {
        public SimpleListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }

    @ClientListener(converterFactoryName="dynamic-converter-factory", includeCurrentState=true)
    public static class DynamicCustomEventWithStateLogListener<K>
    extends CustomEventLogListener<K, CustomEvent> {
        public DynamicCustomEventWithStateLogListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }

    @ClientListener(converterFactoryName="dynamic-converter-factory")
    public static class DynamicCustomEventLogListener<K>
    extends CustomEventLogListener<K, CustomEvent> {
        public DynamicCustomEventLogListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }

    @ClientListener(converterFactoryName="static-converter-factory", includeCurrentState=true)
    public static class StaticCustomEventLogWithStateListener<K>
    extends CustomEventLogListener<K, CustomEvent> {
        public StaticCustomEventLogWithStateListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }

    @ClientListener(converterFactoryName="raw-static-converter-factory", useRawData=true)
    public static class RawStaticCustomEventLogListener<K>
    extends CustomEventLogListener<K, byte[]> {
        public RawStaticCustomEventLogListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }

    @ClientListener(converterFactoryName="static-converter-factory")
    public static class StaticCustomEventLogListener<K>
    extends CustomEventLogListener<K, CustomEvent> {
        public StaticCustomEventLogListener(RemoteCache<K, ?> r) {
            super(r);
        }

        @Override
        public void expectSingleCustomEvent(ClientEvent.Type type, CustomEvent expected) {
            CustomEvent event = (CustomEvent)this.pollEvent(type);
            AssertJUnit.assertNotNull((Object)event.key);
            AssertJUnit.assertNotNull((Object)event.timestamp);
            TestingUtil.assertAnyEquals((Object)expected, (Object)event);
        }

        public void expectOrderedEventQueue(ClientEvent.Type type) {
            BlockingQueue queue = this.queue(type);
            if (queue.size() < 2) {
                return;
            }
            try {
                CustomEvent before = (CustomEvent)queue.poll(10L, TimeUnit.SECONDS);
                for (CustomEvent after : queue) {
                    this.expectTimeOrdered(before, after);
                    before = after;
                }
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }

        private void expectTimeOrdered(CustomEvent before, CustomEvent after) {
            AssertJUnit.assertTrue((String)("Before timestamp=" + before.timestamp + ", after timestamp=" + after.timestamp), (before.timestamp < after.timestamp ? 1 : 0) != 0);
        }
    }

    public static final class CustomEvent<K> {
        @ProtoField(value=1)
        final WrappedMessage key;
        @ProtoField(value=2)
        final String value;
        @ProtoField(number=3, defaultValue="-1")
        final long timestamp;
        @ProtoField(number=4, defaultValue="0")
        final int counter;

        public CustomEvent(K key, String value, int counter) {
            this(new WrappedMessage(key), value, System.nanoTime(), counter);
        }

        @ProtoFactory
        CustomEvent(WrappedMessage key, String value, long timestamp, int counter) {
            this.key = key;
            this.value = value;
            this.timestamp = timestamp;
            this.counter = counter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomEvent that = (CustomEvent)o;
            if (this.counter != that.counter) {
                return false;
            }
            if (!this.key.getValue().equals(that.key.getValue())) {
                return false;
            }
            return !(this.value == null ? that.value != null : !this.value.equals(that.value));
        }

        public int hashCode() {
            int result = this.key.getValue().hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + this.counter;
            return result;
        }

        public String toString() {
            return "CustomEvent{key=" + this.key.getValue() + ", value='" + this.value + "', timestamp=" + this.timestamp + ", counter=" + this.counter + "}";
        }
    }
}

