/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.impl.iteration.AbstractRemoteIteratorTest;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AccountPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.iteration.ProtobufRemoteIteratorTest")
public class ProtobufRemoteIteratorTest
extends MultiHotRodServersTest
implements AbstractRemoteIteratorTest {
    private static final int NUM_NODES = 2;
    private static final int CACHE_SIZE = 10;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfgBuilder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)ProtobufRemoteIteratorTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        cfgBuilder.encoding().key().mediaType("application/x-protostream");
        cfgBuilder.encoding().value().mediaType("application/x-protostream");
        this.createHotRodServers(2, cfgBuilder);
        this.waitForClusterToForm();
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestDomainSCI.INSTANCE;
    }

    public void testSimpleIteration() {
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(10, this::newAccountPB, cache);
        ArrayList results = new ArrayList();
        cache.retrieveEntries(null, null, 10).forEachRemaining(e -> results.add((AccountPB)e.getValue()));
        Assert.assertEquals((int)10, (int)results.size());
    }

    public void testFilteredIteration() {
        this.servers.forEach(s -> s.addKeyValueFilterConverterFactory("filterName", (KeyValueFilterConverterFactory)new ToStringFilterConverterFactory()));
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(10, this::newAccountPB, cache);
        Set segments = this.rangeAsSet(1, 30);
        HashSet results = new HashSet();
        cache.retrieveEntries("filterName", segments, 10).forEachRemaining(results::add);
        Set values = this.extractValues(results);
        this.assertForAll(values, s -> s instanceof String);
        Marshaller marshaller = ((RemoteCacheManager)this.clients.iterator().next()).getMarshaller();
        LocalizedCacheTopology cacheTopology = this.advancedCache(0).getDistributionManager().getCacheTopology();
        this.assertKeysInSegment(results, segments, marshaller, arg_0 -> ((LocalizedCacheTopology)cacheTopology).getSegment(arg_0));
    }

    public void testFilteredIterationWithQuery() {
        RemoteCache remoteCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(10, this::newAccountPB, remoteCache);
        QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)remoteCache);
        int lowerId = 5;
        int higherId = 8;
        Query simpleQuery = queryFactory.create("FROM sample_bank_account.Account WHERE id BETWEEN :lowerId AND :higherId").setParameter("lowerId", (Object)lowerId).setParameter("higherId", (Object)higherId);
        Set entries = this.extractEntries(remoteCache.retrieveEntriesByQuery(simpleQuery, null, 10));
        Set keys = this.extractKeys(entries);
        Assert.assertEquals((int)4, (int)keys.size());
        this.assertForAll(keys, key -> key >= lowerId && key <= higherId);
        this.assertForAll(entries, e -> e.getValue() instanceof AccountPB);
        Query projectionsQuery = queryFactory.create("SELECT id, description FROM sample_bank_account.Account WHERE id BETWEEN :lowerId AND :higherId").setParameter("lowerId", (Object)lowerId).setParameter("higherId", (Object)higherId);
        Set entriesWithProjection = this.extractEntries(remoteCache.retrieveEntriesByQuery(projectionsQuery, null, 10));
        Assert.assertEquals((int)4, (int)entriesWithProjection.size());
        this.assertForAll(entriesWithProjection, entry -> {
            Integer id = (Integer)entry.getKey();
            Object[] projection = (Object[])entry.getValue();
            return projection[0].equals(id) && projection[1].equals("description for " + id);
        });
    }

    static final class ToStringFilterConverter
    extends AbstractKeyValueFilterConverter<Integer, AccountPB, String>
    implements Serializable {
        ToStringFilterConverter() {
        }

        public String filterAndConvert(Integer key, AccountPB value, Metadata metadata) {
            return value.toString();
        }
    }

    static final class ToStringFilterConverterFactory
    implements KeyValueFilterConverterFactory<Integer, AccountPB, String>,
    Serializable {
        ToStringFilterConverterFactory() {
        }

        public KeyValueFilterConverter<Integer, AccountPB, String> getFilterConverter() {
            return new ToStringFilterConverter();
        }
    }
}

