/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.multimap;

import java.util.Collection;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.multimap.MetadataCollection;
import org.infinispan.client.hotrod.multimap.MultimapCacheManager;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCache;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCacheManagerFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.RemoteMultimapCacheAPITWithDuplicatesTest")
public class RemoteMultimapCacheAPITWithDuplicatesTest
extends SingleHotRodServerTest {
    private static final String TEST_CACHE_NAME = RemoteMultimapCacheAPITWithDuplicatesTest.class.getSimpleName();
    private RemoteMultimapCache<String, String> multimapCache;

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.forceReturnValues(this.isForceReturnValuesViaConfiguration()).maxRetries(0);
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        return new InternalRemoteCacheManager(builder.build());
    }

    @Override
    protected void setup() throws Exception {
        this.cacheManager = this.createCacheManager();
        this.hotrodServer = this.createHotRodServer();
        this.remoteCacheManager = this.getRemoteCacheManager();
        this.remoteCacheManager.start();
        this.cacheManager.defineConfiguration(TEST_CACHE_NAME, new org.infinispan.configuration.cache.ConfigurationBuilder().build());
        MultimapCacheManager rmc = RemoteMultimapCacheManagerFactory.from((RemoteCacheManager)this.remoteCacheManager);
        this.multimapCache = rmc.get(TEST_CACHE_NAME, true);
    }

    protected boolean isForceReturnValuesViaConfiguration() {
        return true;
    }

    public void testSupportsDuplicates() {
        AssertJUnit.assertTrue((boolean)this.multimapCache.supportsDuplicates());
    }

    public void testPut() {
        this.multimapCache.put((Object)"k", (Object)"a").join();
        this.multimapCache.put((Object)"k", (Object)"a").join();
        this.multimapCache.put((Object)"k", (Object)"a").join();
        Collection kValues = (Collection)this.multimapCache.get((Object)"k").join();
        AssertJUnit.assertEquals((int)3, (int)kValues.size());
        AssertJUnit.assertTrue((boolean)kValues.contains("a"));
    }

    public void testGetWithMetadata() throws Exception {
        this.multimapCache.put((Object)"k", (Object)"a").join();
        this.multimapCache.put((Object)"k", (Object)"a").join();
        this.multimapCache.put((Object)"k", (Object)"c").join();
        MetadataCollection metadataCollection = (MetadataCollection)this.multimapCache.getWithMetadata((Object)"k").join();
        AssertJUnit.assertEquals((int)3, (int)metadataCollection.getCollection().size());
        AssertJUnit.assertTrue((boolean)metadataCollection.getCollection().contains("a"));
        AssertJUnit.assertEquals((int)-1, (int)metadataCollection.getLifespan());
        AssertJUnit.assertEquals((long)0L, (long)metadataCollection.getVersion());
    }

    public void testRemoveKeyValue() {
        this.multimapCache.put((Object)"k", (Object)"a").join();
        this.multimapCache.put((Object)"k", (Object)"a").join();
        this.multimapCache.put((Object)"k", (Object)"c").join();
        Collection kValues = (Collection)this.multimapCache.get((Object)"k").join();
        AssertJUnit.assertEquals((int)3, (int)kValues.size());
        AssertJUnit.assertTrue((boolean)((Boolean)this.multimapCache.remove((Object)"k", (Object)"a").join()));
        AssertJUnit.assertEquals((int)1, (int)((Collection)this.multimapCache.get((Object)"k").join()).size());
    }
}

