/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.near.AvoidStaleNearCacheReadsTest")
public class AvoidStaleNearCacheReadsTest
extends SingleHotRodServerTest {
    private int entryCount;
    private boolean bloomFilter;

    @AfterMethod(alwaysRun=true)
    protected void clearContent() {
        super.clearContent();
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        remoteCache.clear();
        if (this.bloomFilter) {
            CompletionStages.join((CompletionStage)((InternalRemoteCache)remoteCache).updateBloomFilter());
        }
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        NearCacheConfigurationBuilder nearCacheConfigurationBuilder = builder.nearCache().mode(NearCacheMode.INVALIDATED).maxEntries(this.entryCount).bloomFilter(this.bloomFilter);
        if (this.bloomFilter) {
            builder.connectionPool().maxActive(1);
        }
        return new RemoteCacheManager(builder.build());
    }

    AvoidStaleNearCacheReadsTest entryCount(int entryCount) {
        this.entryCount = entryCount;
        return this;
    }

    AvoidStaleNearCacheReadsTest bloomFilter(boolean bloomFilter) {
        this.bloomFilter = bloomFilter;
        return this;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new AvoidStaleNearCacheReadsTest().entryCount(-1), new AvoidStaleNearCacheReadsTest().entryCount(20).bloomFilter(false), new AvoidStaleNearCacheReadsTest().entryCount(20).bloomFilter(true)};
    }

    protected String parameters() {
        return "maxEntries=" + this.entryCount + ", bloomFilter=" + this.bloomFilter;
    }

    public void testAvoidStaleReadsAfterPutRemove() {
        this.repeated((i, remote) -> {
            String value = "v" + i;
            remote.put((Object)1, (Object)value);
            AssertJUnit.assertEquals((String)value, (String)((String)remote.get((Object)1)));
            remote.remove((Object)1);
            AssertJUnit.assertNull((Object)remote.get((Object)1));
        });
    }

    public void testAvoidStaleReadsAfterPutAll() {
        this.repeated((i, remote) -> {
            String value = "v" + i;
            HashMap<Integer, CallSite> map = new HashMap<Integer, CallSite>();
            map.put(1, (CallSite)((Object)value));
            remote.putAll(map);
            AssertJUnit.assertEquals((String)value, (String)((String)remote.get((Object)1)));
        });
    }

    public void testAvoidStaleReadsAfterReplace() {
        this.repeated((i, remote) -> {
            String value = "v" + i;
            remote.replace((Object)1, (Object)value);
            MetadataValue versioned = remote.getWithMetadata((Object)1);
            AssertJUnit.assertEquals((String)value, (String)((String)versioned.getValue()));
        });
    }

    public void testAvoidStaleReadsAfterReplaceWithVersion() {
        this.repeated((i, remote) -> {
            String value = "v" + i;
            MetadataValue versioned = remote.getWithMetadata((Object)1);
            remote.replaceWithVersion((Object)1, (Object)value, versioned.getVersion());
            AssertJUnit.assertEquals((String)value, (String)((String)remote.get((Object)1)));
        });
    }

    public void testAvoidStaleReadsAfterPutAsyncRemoveVersioned() {
        this.repeated((i, remote) -> {
            String value = "v" + i;
            AvoidStaleNearCacheReadsTest.await(remote.putAsync((Object)1, (Object)value));
            MetadataValue versioned = remote.getWithMetadata((Object)1);
            AssertJUnit.assertEquals((String)value, (String)((String)versioned.getValue()));
            remote.removeWithVersion((Object)1, versioned.getVersion());
            AssertJUnit.assertNull((Object)remote.get((Object)1));
        });
    }

    private void repeated(BiConsumer<Integer, RemoteCache<Integer, String>> c) {
        RemoteCache remote = this.remoteCacheManager.getCache();
        remote.putIfAbsent((Object)1, (Object)"v0");
        IntStream.range(1, 1000).forEach(i -> c.accept(i, remote));
    }

    static <T> T await(Future<T> f) {
        try {
            return f.get(10000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }
}

