/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.impl.InvalidatedNearRemoteCache;
import org.infinispan.client.hotrod.near.AssertsNearCache;
import org.infinispan.client.hotrod.near.InvalidatedFailoverNearCacheTest;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.near.InvalidatedFailoverNearCacheBloomTest")
public class InvalidatedFailoverNearCacheBloomTest
extends InvalidatedFailoverNearCacheTest {
    @Override
    protected <K, V> AssertsNearCache<K, V> createStickyAssertClient() {
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        for (HotRodServer server : this.servers) {
            clientBuilder.addServer().host("127.0.0.1").port(server.getPort().intValue());
        }
        clientBuilder.connectionPool().maxActive(1);
        clientBuilder.nearCache().mode(NearCacheMode.INVALIDATED).maxEntries(4).bloomFilter(true);
        return AssertsNearCache.create(this.cache(0), clientBuilder);
    }

    @Override
    protected void killServerForClient(AssertsNearCache<Integer, String> stickyClient) {
        boolean stoppedAServer = false;
        SocketAddress socketAddress = ((InvalidatedNearRemoteCache)stickyClient.remote).getBloomListenerAddress();
        for (HotRodServer server : this.servers) {
            int serverPort = server.getAddress().getPort();
            if (serverPort != ((InetSocketAddress)socketAddress).getPort()) continue;
            HotRodClientTestingUtil.killServers(server);
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{server.getCacheManager()});
            this.cacheManagers.remove(server.getCacheManager());
            TestingUtil.blockUntilViewsReceived((int)50000, (boolean)false, (Collection)this.cacheManagers);
            stoppedAServer = true;
            break;
        }
        AssertJUnit.assertTrue((String)("Could not find a server that mapped to " + socketAddress), (boolean)stoppedAServer);
    }

    @Override
    protected boolean isClientListenerAttachedToSameServer(AssertsNearCache<Integer, String> client1, AssertsNearCache<Integer, String> client2) {
        SocketAddress client1Address = ((InvalidatedNearRemoteCache)client1.remote).getBloomListenerAddress();
        SocketAddress client2Address = ((InvalidatedNearRemoteCache)client2.remote).getBloomListenerAddress();
        return client1Address.equals(client2Address);
    }
}

