/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Indexer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.ReindexCacheTest", groups={"functional"})
public class ReindexCacheTest
extends SingleHotRodServerTest {
    private static final String USER_CACHE = "users";
    private static final int NUM_ENTRIES = 50;
    private StorageType storageType;

    @Factory
    public Object[] factory() {
        return new Object[]{new ReindexCacheTest().storageType(StorageType.OBJECT), new ReindexCacheTest().storageType(StorageType.OFF_HEAP)};
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createServerModeCacheManager((SerializationContextInitializer)this.contextInitializer(), (ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.defineConfiguration(USER_CACHE, HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)this.buildIndexedConfig()).build());
        return this.cacheManager;
    }

    protected String parameters() {
        return "storageType-" + this.storageType;
    }

    private ReindexCacheTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    public ConfigurationBuilder buildIndexedConfig() {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)new ConfigurationBuilder());
        builder.memory().storageType(this.storageType).indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("sample_bank_account.User");
        return builder;
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestDomainSCI.INSTANCE;
    }

    @Test
    public void testMassIndexing() {
        RemoteCache userCache = this.remoteCacheManager.getCache(USER_CACHE);
        for (int i = 0; i < 50; ++i) {
            UserPB user = new UserPB();
            user.setId(i);
            user.setName("name" + i);
            user.setSurname("surname" + i);
            userCache.put((Object)user.getId(), (Object)user);
        }
        Assert.assertEquals((long)this.query(userCache), (long)50L);
        this.wipeIndexes();
        this.assertIndexEmpty();
        this.reindex();
        Assert.assertEquals((long)this.query(userCache), (long)50L);
    }

    private void wipeIndexes() {
        Cache cache = this.cacheManager.getCache(USER_CACHE);
        Indexer indexer = org.infinispan.query.Search.getIndexer((Cache)cache);
        CompletionStages.join((CompletionStage)indexer.remove());
    }

    private void assertIndexEmpty() {
        Assert.assertEquals((long)this.query(this.remoteCacheManager.getCache(USER_CACHE)), (long)0L);
    }

    private void reindex() {
        Cache cache = this.cacheManager.getCache(USER_CACHE);
        Indexer indexer = org.infinispan.query.Search.getIndexer((Cache)cache);
        CompletionStages.join((CompletionStage)indexer.run());
    }

    private long query(RemoteCache<?, ?> cache) {
        QueryFactory qf = Search.getQueryFactory(cache);
        Query q = qf.create("FROM sample_bank_account.User");
        return q.execute().hitCount().orElse(-1L);
    }
}

