/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.query.RemoteQueryDslConditionsFilesystemTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.RemoteQueryDslConditionsTunedTest", groups={"functional"})
public class RemoteQueryDslConditionsTunedTest
extends RemoteQueryDslConditionsFilesystemTest {
    private static final int NUM_SHARDS = 6;

    @Override
    protected ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.FILESYSTEM).path(this.indexDirectory).addIndexedEntity("sample_bank_account.User").addIndexedEntity("sample_bank_account.Account").addIndexedEntity("sample_bank_account.Transaction").writer().ramBufferSize(220).merge().factor(30).maxSize(4096);
        return builder;
    }

    @Override
    public void testIndexPresence() {
        SearchMapping searchMapping = (SearchMapping)TestingUtil.extractComponent((Cache)this.cache, SearchMapping.class);
        AssertJUnit.assertNotNull((Object)searchMapping.indexedEntity("sample_bank_account.User"));
        AssertJUnit.assertNotNull((Object)searchMapping.indexedEntity("sample_bank_account.Account"));
        AssertJUnit.assertNotNull((Object)searchMapping.indexedEntity("sample_bank_account.Transaction"));
        AssertJUnit.assertEquals((int)3, (int)searchMapping.allIndexedEntities().size());
    }
}

