/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.Iterator;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.retry.AbstractRetryTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.retry.ReplicationRetryTest", groups={"functional"})
public class ReplicationRetryTest
extends AbstractRetryTest {
    public void testGet() {
        this.validateSequenceAndStopServer();
        this.resetStats();
        for (int i = 0; i < 100; ++i) {
            assert (this.remoteCache.get((Object)"k").equals("v"));
        }
    }

    public void testPut() {
        this.validateSequenceAndStopServer();
        this.resetStats();
        Assert.assertEquals((Object)this.remoteCache.put((Object)"k", (Object)"v0"), (Object)"v");
        for (int i = 1; i < 100; ++i) {
            Assert.assertEquals((Object)("v" + (i - 1)), (Object)this.remoteCache.put((Object)"k", (Object)("v" + i)));
        }
    }

    public void testRemove() {
        this.validateSequenceAndStopServer();
        this.resetStats();
        Assert.assertEquals((Object)"v", (Object)this.remoteCache.remove((Object)"k"));
    }

    public void testContains() {
        this.validateSequenceAndStopServer();
        this.resetStats();
        Assert.assertEquals((boolean)true, (boolean)this.remoteCache.containsKey((Object)"k"));
    }

    public void testGetWithMetadata() {
        this.validateSequenceAndStopServer();
        this.resetStats();
        MetadataValue value = this.remoteCache.getWithMetadata((Object)"k");
        Assert.assertEquals((Object)"v", (Object)value.getValue());
    }

    public void testPutIfAbsent() {
        this.validateSequenceAndStopServer();
        this.resetStats();
        Assert.assertEquals(null, (Object)this.remoteCache.putIfAbsent((Object)"noSuchKey", (Object)"someValue"));
        Assert.assertEquals((Object)"someValue", (Object)this.remoteCache.get((Object)"noSuchKey"));
    }

    public void testReplace() {
        this.validateSequenceAndStopServer();
        this.resetStats();
        Assert.assertEquals((Object)"v", (Object)this.remoteCache.replace((Object)"k", (Object)"v2"));
    }

    public void testReplaceIfUnmodified() {
        this.validateSequenceAndStopServer();
        this.resetStats();
        Assert.assertEquals((boolean)false, (boolean)this.remoteCache.replaceWithVersion((Object)"k", (Object)"v2", 12L));
    }

    public void testRemoveIfUnmodified() {
        this.validateSequenceAndStopServer();
        this.resetStats();
        Assert.assertEquals((boolean)false, (boolean)this.remoteCache.removeWithVersion((Object)"k", 12L));
    }

    public void testClear() {
        this.validateSequenceAndStopServer();
        this.resetStats();
        this.remoteCache.clear();
        Assert.assertEquals((boolean)false, (boolean)this.remoteCache.containsKey((Object)"k"));
    }

    private void validateSequenceAndStopServer() {
        ConsistentHash consistentHash = this.channelFactory.getConsistentHash(RemoteCacheManager.cacheNameBytes());
        this.resetStats();
        this.assertNoHits();
        SocketAddress expectedServer = consistentHash.getServer((Object)HotRodTestingUtil.marshall((Object)"k"));
        this.assertNoHits();
        this.remoteCache.put((Object)"k", (Object)"v");
        assert (this.strategy.getServers().length == 3);
        this.assertOnlyServerHit(expectedServer);
        this.resetStats();
        expectedServer = consistentHash.getServer((Object)HotRodTestingUtil.marshall((Object)"k2"));
        this.remoteCache.put((Object)"k2", (Object)"v2");
        this.assertOnlyServerHit(expectedServer);
        this.resetStats();
        expectedServer = consistentHash.getServer((Object)HotRodTestingUtil.marshall((Object)"k3"));
        this.remoteCache.put((Object)"k3", (Object)"v3");
        this.assertOnlyServerHit(expectedServer);
        this.resetStats();
        expectedServer = consistentHash.getServer((Object)HotRodTestingUtil.marshall((Object)"k"));
        Assert.assertEquals((Object)"v", (Object)this.remoteCache.put((Object)"k", (Object)"v"));
        this.assertOnlyServerHit(expectedServer);
        expectedServer = consistentHash.getServer((Object)HotRodTestingUtil.marshall((Object)"k"));
        HotRodServer toStop = (HotRodServer)this.addr2hrServer.get(expectedServer);
        toStop.stop();
        Iterator ecmIt = this.cacheManagers.iterator();
        while (ecmIt.hasNext()) {
            if (!((EmbeddedCacheManager)ecmIt.next()).getAddress().equals(expectedServer)) continue;
            ecmIt.remove();
        }
        TestingUtil.waitForNoRebalance((Collection)this.caches());
    }

    @Override
    protected ConfigurationBuilder getCacheConfig() {
        return ReplicationRetryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
    }
}

