/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.test;

import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;

public abstract class SingleHotRodServerTest
extends SingleCacheManagerTest {
    protected HotRodServer hotrodServer;
    protected RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)this.contextInitializer(), (org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = this.createHotRodServer();
        this.remoteCacheManager = this.getRemoteCacheManager();
        this.remoteCacheManager.getCache();
    }

    protected HotRodServer createHotRodServer() {
        return HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
    }

    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = this.createHotRodClientConfigurationBuilder("127.0.0.1", this.hotrodServer.getPort());
        return new InternalRemoteCacheManager(builder.build());
    }

    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host(host).port(serverPort);
        SerializationContextInitializer sci = this.contextInitializer();
        if (sci != null) {
            builder.addContextInitializer(sci);
        }
        return builder;
    }

    protected SerializationContextInitializer contextInitializer() {
        return null;
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        this.hotrodServer = null;
        this.remoteCacheManager = null;
        super.teardown();
    }
}

