/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.xsite;

import java.util.Optional;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.xsite.AbstractHotRodSiteFailoverTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.xsite.SiteManualSwitchTest")
public class SiteManualSwitchTest
extends AbstractHotRodSiteFailoverTest {
    private RemoteCacheManager clientA;
    private RemoteCacheManager clientB;

    @Override
    protected void createSites() {
        super.createSites();
        this.addHitCountInterceptors();
    }

    @AfterMethod(alwaysRun=true)
    public void killClients() {
        HotRodClientTestingUtil.killRemoteCacheManagers(this.clientA, this.clientB);
    }

    public void testManualClusterSwitch() {
        this.clientA = this.client("LON-1", Optional.of("NYC-2"));
        this.clientB = this.client("NYC-2", Optional.empty());
        RemoteCache cacheA = this.clientA.getCache("testCache");
        RemoteCache cacheB = this.clientB.getCache("testCache");
        this.assertNoHits();
        this.assertSingleSiteHit("LON-1", "NYC-2", () -> AssertJUnit.assertNull((Object)cacheA.put((Object)1, (Object)"v1")));
        this.assertSingleSiteHit("LON-1", "NYC-2", () -> AssertJUnit.assertEquals((String)"v1", (String)((String)cacheA.get((Object)1))));
        this.assertSingleSiteHit("NYC-2", "LON-1", () -> AssertJUnit.assertNull((Object)cacheB.put((Object)2, (Object)"v2")));
        this.assertSingleSiteHit("NYC-2", "LON-1", () -> AssertJUnit.assertEquals((String)"v2", (String)((String)cacheB.get((Object)2))));
        AssertJUnit.assertTrue((boolean)this.clientA.switchToCluster("NYC-2"));
        this.assertSingleSiteHit("NYC-2", "LON-1", () -> AssertJUnit.assertNull((Object)cacheA.put((Object)3, (Object)"v3")));
        this.assertSingleSiteHit("NYC-2", "LON-1", () -> AssertJUnit.assertEquals((String)"v3", (String)((String)cacheA.get((Object)3))));
        AssertJUnit.assertTrue((boolean)this.clientA.switchToDefaultCluster());
        this.assertSingleSiteHit("LON-1", "NYC-2", () -> AssertJUnit.assertNull((Object)cacheA.put((Object)4, (Object)"v4")));
        this.assertSingleSiteHit("LON-1", "NYC-2", () -> AssertJUnit.assertEquals((String)"v4", (String)((String)cacheA.get((Object)4))));
    }

    public void testManualClusterSwitchViaJMX() throws Exception {
        this.clientA = this.client("LON-1", Optional.of("NYC-2"));
        this.clientB = this.client("NYC-2", Optional.empty());
        MBeanServer mbeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName objectName = HotRodClientTestingUtil.remoteCacheManagerObjectName(this.clientA);
        RemoteCache cacheA = this.clientA.getCache("testCache");
        RemoteCache cacheB = this.clientB.getCache("testCache");
        this.assertNoHits();
        this.assertSingleSiteHit("LON-1", "NYC-2", () -> AssertJUnit.assertNull((Object)cacheA.put((Object)1, (Object)"v1")));
        this.assertSingleSiteHit("LON-1", "NYC-2", () -> AssertJUnit.assertEquals((String)"v1", (String)((String)cacheA.get((Object)1))));
        this.assertSingleSiteHit("NYC-2", "LON-1", () -> AssertJUnit.assertNull((Object)cacheB.put((Object)2, (Object)"v2")));
        this.assertSingleSiteHit("NYC-2", "LON-1", () -> AssertJUnit.assertEquals((String)"v2", (String)((String)cacheB.get((Object)2))));
        Object switched = mbeanServer.invoke(objectName, "switchToCluster", new Object[]{"NYC-2"}, new String[]{String.class.getName()});
        AssertJUnit.assertEquals((Object)Boolean.TRUE, (Object)switched);
        this.assertSingleSiteHit("NYC-2", "LON-1", () -> AssertJUnit.assertNull((Object)cacheA.put((Object)3, (Object)"v3")));
        this.assertSingleSiteHit("NYC-2", "LON-1", () -> AssertJUnit.assertEquals((String)"v3", (String)((String)cacheA.get((Object)3))));
        switched = mbeanServer.invoke(objectName, "switchToDefaultCluster", new Object[0], new String[0]);
        AssertJUnit.assertEquals((Object)Boolean.TRUE, (Object)switched);
        this.assertSingleSiteHit("LON-1", "NYC-2", () -> AssertJUnit.assertNull((Object)cacheA.put((Object)4, (Object)"v4")));
        this.assertSingleSiteHit("LON-1", "NYC-2", () -> AssertJUnit.assertEquals((String)"v4", (String)((String)cacheA.get((Object)4))));
    }

    private void assertSingleSiteHit(String siteHit, String siteNotHit, Runnable r) {
        r.run();
        this.assertSiteHit(siteHit, 1);
        this.assertSiteNotHit(siteNotHit);
        this.resetHitCounters();
    }
}

