/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.tx.util.KeyValueGenerator;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.HotRodServer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.APITest")
public class APITest<K, V>
extends MultiHotRodServersTest {
    private static final int NR_NODES = 2;
    private static final String CACHE_NAME = "api-cache";
    private KeyValueGenerator<K, V> kvGenerator;
    private boolean useJavaSerialization;
    private ProtocolVersion protocolVersion;

    public Object[] factory() {
        return Arrays.stream(ProtocolVersion.values()).filter(pv -> !pv.name().equals("PROTOCOL_VERSION_AUTO")).flatMap(pv -> Stream.of(new APITest<byte[], byte[]>().keyValueGenerator(KeyValueGenerator.BYTE_ARRAY_GENERATOR).protocolVersion((ProtocolVersion)pv), new APITest<String, String>().keyValueGenerator(KeyValueGenerator.STRING_GENERATOR).protocolVersion((ProtocolVersion)pv), new APITest<Object[], Object[]>().keyValueGenerator(KeyValueGenerator.GENERIC_ARRAY_GENERATOR).javaSerialization().protocolVersion((ProtocolVersion)pv))).toArray(Object[]::new);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(HotRodServer server) {
        ConfigurationBuilder builder = super.createHotRodClientConfigurationBuilder(server);
        builder.version(this.protocolVersion);
        return builder;
    }

    public void testCompute(Method method) {
        RemoteCache cache = this.remoteCache();
        Object key = this.kvGenerator.generateKey(method, 0);
        V value = this.kvGenerator.generateValue(method, 0);
        BiFunction<Object, Object, Object> sameValueFunction = (k, v) -> v;
        cache.put(key, value);
        this.kvGenerator.assertValueEquals(value, cache.compute(key, sameValueFunction));
        this.kvGenerator.assertValueEquals(value, cache.get(key));
        Object value1 = this.kvGenerator.generateValue(method, 1);
        BiFunction<Object, Object, Object> differentValueFunction = (k, v) -> value1;
        this.kvGenerator.assertValueEquals(value1, cache.compute(key, differentValueFunction));
        this.kvGenerator.assertValueEquals(value1, cache.get(key));
        K notPresentKey = this.kvGenerator.generateKey(method, 1);
        this.kvGenerator.assertValueEquals(value1, cache.compute(notPresentKey, differentValueFunction));
        this.kvGenerator.assertValueEquals(value1, cache.get(notPresentKey));
        BiFunction<Object, Object, Object> mappingToNull = (k, v) -> null;
        AssertJUnit.assertNull((String)"mapping to null returns null", (Object)cache.compute(key, mappingToNull));
        AssertJUnit.assertNull((String)"the key is removed", (Object)cache.get(key));
        int cacheSizeBeforeNullValueCompute = cache.size();
        K nonExistantKey = this.kvGenerator.generateKey(method, 3);
        AssertJUnit.assertNull((String)"mapping to null returns null", (Object)cache.compute(nonExistantKey, mappingToNull));
        AssertJUnit.assertNull((String)"the key does not exist", (Object)cache.get(nonExistantKey));
        AssertJUnit.assertEquals((int)cacheSizeBeforeNullValueCompute, (int)cache.size());
        RuntimeException computeRaisedException = new RuntimeException("hi there");
        BiFunction<Object, Object, Object> mappingToException = (k, v) -> {
            throw computeRaisedException;
        };
        Exceptions.expectException(TransportException.class, RuntimeException.class, (String)"hi there", () -> cache.compute(key, mappingToException));
    }

    public void testComputeIfAbsentMethods(Method method) {
        RemoteCache cache = this.remoteCache();
        Object targetKey = this.kvGenerator.generateKey(method, 0);
        Function<Object, Object> remappingFunction = key -> this.kvGenerator.generateValue(method, 1);
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfAbsent(targetKey, remappingFunction));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfAbsent(targetKey, remappingFunction, 1L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfAbsent(targetKey, remappingFunction, 1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfAbsentAsync(targetKey, remappingFunction));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfAbsentAsync(targetKey, remappingFunction, 1L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfAbsentAsync(targetKey, remappingFunction, 1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS));
    }

    public void testComputeIfPresentMethods(Method method) {
        RemoteCache cache = this.remoteCache();
        Object targetKey = this.kvGenerator.generateKey(method, 0);
        BiFunction<Object, Object, Object> remappingFunction = (key, value) -> this.kvGenerator.generateValue(method, 1);
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfPresent(targetKey, remappingFunction));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfPresent(targetKey, remappingFunction, 1L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfPresent(targetKey, remappingFunction, 1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfPresentAsync(targetKey, remappingFunction));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfPresentAsync(targetKey, remappingFunction, 1L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfPresentAsync(targetKey, remappingFunction, 1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS));
    }

    public void testMergeMethods(Method method) {
        RemoteCache cache = this.remoteCache();
        Object targetKey = this.kvGenerator.generateKey(method, 0);
        Object targetValue = this.kvGenerator.generateValue(method, 0);
        BiFunction<Object, Object, Object> remappingFunction = (value1, value2) -> this.kvGenerator.generateValue(method, 2);
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.merge(targetKey, targetValue, remappingFunction));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.merge(targetKey, targetValue, remappingFunction, 1L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.merge(targetKey, targetValue, remappingFunction, 1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.mergeAsync(targetKey, targetValue, remappingFunction));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.mergeAsync(targetKey, targetValue, remappingFunction, 1L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.mergeAsync(targetKey, targetValue, remappingFunction, 1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS));
    }

    public void testPut(Method method) {
        RemoteCache<K, V> cache = this.remoteCache();
        K targetKey = this.kvGenerator.generateKey(method, 0);
        V targetValue = this.kvGenerator.generateValue(method, 0);
        AssertJUnit.assertNull((Object)cache.put(targetKey, targetValue));
        this.kvGenerator.assertValueEquals(targetValue, cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put(targetKey, this.kvGenerator.generateValue(method, 2)));
    }

    public void testPutIfAbsent(Method method) {
        RemoteCache<K, V> cache = this.remoteCache();
        K targetKey = this.kvGenerator.generateKey(method, 0);
        V targetValue = this.kvGenerator.generateValue(method, 0);
        AssertJUnit.assertNull((Object)cache.putIfAbsent(targetKey, targetValue));
        this.kvGenerator.assertValueEquals(targetValue, cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent(targetKey, this.kvGenerator.generateValue(method, 2)));
    }

    public void testRemove(Method method) {
        RemoteCache<K, V> cache = this.remoteCache();
        K targetKey = this.kvGenerator.generateKey(method, 0);
        V targetValue = this.kvGenerator.generateValue(method, 0);
        AssertJUnit.assertNull((Object)cache.put(targetKey, targetValue));
        this.kvGenerator.assertValueEquals(targetValue, cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove(targetKey));
    }

    protected String[] parameterNames() {
        return (String[])APITest.concat((Object[])super.parameterNames(), (Object[])new String[]{"kv", "protocolVersion"});
    }

    protected Object[] parameterValues() {
        return APITest.concat((Object[])super.parameterValues(), (Object[])new Object[]{this.kvGenerator.toString(), this.protocolVersion.getVersion()});
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cacheBuilder = APITest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        this.createHotRodServers(2, new org.infinispan.configuration.cache.ConfigurationBuilder());
        this.defineInAll(CACHE_NAME, cacheBuilder);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder clientBuilder = super.createHotRodClientConfigurationBuilder(host, serverPort);
        clientBuilder.forceReturnValues(false);
        if (this.useJavaSerialization) {
            clientBuilder.marshaller((Marshaller)new JavaSerializationMarshaller()).addJavaSerialAllowList(new String[]{"\\Q[\\ELjava.lang.Object;"});
        }
        return clientBuilder;
    }

    private APITest<K, V> keyValueGenerator(KeyValueGenerator<K, V> kvGenerator) {
        this.kvGenerator = kvGenerator;
        return this;
    }

    public APITest<K, V> javaSerialization() {
        this.useJavaSerialization = true;
        return this;
    }

    public APITest<K, V> protocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        return this;
    }

    private RemoteCache<K, V> remoteCache() {
        return this.client(0).getCache(CACHE_NAME);
    }
}

