/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Collections;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.client.hotrod.AbstractAuthenticationTest;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.security.simple.SimpleServerAuthenticationProvider;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestCallbackHandler;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.AuthenticationTest", groups={"functional"})
public class AuthenticationTest
extends AbstractAuthenticationTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.getCache();
        this.hotrodServer = this.initServer(Collections.emptyMap(), 0);
        return this.cacheManager;
    }

    @Override
    protected SimpleServerAuthenticationProvider createAuthenticationProvider() {
        SimpleServerAuthenticationProvider sap = new SimpleServerAuthenticationProvider();
        sap.addUser("user", "realm", "password".toCharArray(), new String[0]);
        return sap;
    }

    @Test
    public void testAuthentication() {
        ConfigurationBuilder clientBuilder = this.newClientBuilder();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("user", "realm", "password"));
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        RemoteCache defaultRemote = this.remoteCacheManager.getCache();
        defaultRemote.put((Object)"a", (Object)"a");
        AssertJUnit.assertEquals((String)"a", (String)((String)defaultRemote.get((Object)"a")));
    }

    @Test
    public void testAuthenticationViaURI() {
        this.remoteCacheManager = new RemoteCacheManager("hotrod://user:password@127.0.0.1:" + this.hotrodServer.getPort() + "?auth_realm=realm&socket_timeout=3000&max_retries=3&connection_pool.max_active=1&sasl_mechanism=CRAM-MD5&default_executor_factory.threadname_prefix=" + TestResourceTracker.getCurrentTestShortName() + "-Client-Async");
        RemoteCache defaultRemote = this.remoteCacheManager.getCache();
        defaultRemote.put((Object)"a", (Object)"a");
        AssertJUnit.assertEquals((String)"a", (String)((String)defaultRemote.get((Object)"a")));
    }

    @Test(expectedExceptions={TransportException.class})
    public void testAuthenticationFailWrongAuth() {
        ConfigurationBuilder clientBuilder = this.newClientBuilder();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("user", "realm", "foobar"));
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCacheManager.getCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN006017:.*")
    public void testAuthenticationFailNoAuth() {
        HotRodServer noAnonymousServer = this.initServer(Collections.singletonMap("javax.security.sasl.policy.noanonymous", "true"), 1);
        try {
            ConfigurationBuilder clientBuilder = this.newClientBuilder(1);
            clientBuilder.security().authentication().disable();
            this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
            RemoteCache cache = this.remoteCacheManager.getCache();
            cache.put((Object)"a", (Object)"a");
        }
        finally {
            ServerTestingUtil.killServer((AbstractProtocolServer)noAnonymousServer);
        }
    }

    @Test
    public void testAuthenticationUsername() {
        ConfigurationBuilder clientBuilder = this.newClientBuilder();
        clientBuilder.security().authentication().username("user").realm("realm").password("password");
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        RemoteCache defaultRemote = this.remoteCacheManager.getCache();
        defaultRemote.put((Object)"a", (Object)"a");
        AssertJUnit.assertEquals((String)"a", (String)((String)defaultRemote.get((Object)"a")));
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp=".*ISPN004067.*")
    public void testAuthenticationUsernameWithCallbackFail() {
        ConfigurationBuilder clientBuilder = this.newClientBuilder();
        clientBuilder.security().authentication().username("user").realm("realm").password("password").callbackHandler((CallbackHandler)new TestCallbackHandler("user", "realm", "foobar"));
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
    }
}

