/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Arrays;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.HotRodServerStartStopTest", groups={"functional"})
public class HotRodServerStartStopTest
extends MultipleCacheManagersTest {
    private static final int FIRST_SERVER_PORT = HotRodServerStartStopTest.randomPort();
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;
    private HotRodServer hotRodServer3;

    private static int randomPort() {
        try {
            ServerSocket socket = new ServerSocket(0);
            return socket.getLocalPort();
        }
        catch (IOException e) {
            return 56001;
        }
    }

    @AfterMethod
    protected void clearContent() {
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodServerStartStopTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.hotRodServer1 = HotRodClientTestingUtil.startHotRodServer(this.manager(0), FIRST_SERVER_PORT, new HotRodServerConfigurationBuilder());
        this.hotRodServer2 = HotRodClientTestingUtil.startHotRodServer(this.manager(1));
        this.hotRodServer3 = HotRodClientTestingUtil.startHotRodServer(this.manager(2));
        this.waitForClusterToForm();
    }

    public void testTouchServer() {
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotRodServer1.getPort().intValue());
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(clientBuilder.build(), true);
        RemoteCache remoteCache = remoteCacheManager.getCache();
        remoteCache.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)remoteCache.get((Object)"k"));
        CacheTopologyInfo info = remoteCache.getCacheTopologyInfo();
        Integer prevTop = info.getTopologyId();
        HotRodClientTestingUtil.killServers(this.hotRodServer1, this.hotRodServer2, this.hotRodServer3);
        Arrays.stream(this.managers()).forEach(Lifecycle::stop);
        this.cacheManagers.clear();
        this.hotRodServer1 = null;
        this.hotRodServer2 = null;
        this.hotRodServer3 = null;
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodServerStartStopTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        this.addClusterEnabledCacheManager(builder);
        this.hotRodServer1 = HotRodClientTestingUtil.startHotRodServer(this.manager(0), FIRST_SERVER_PORT, new HotRodServerConfigurationBuilder());
        AssertJUnit.assertNull((Object)remoteCache.get((Object)"k1"));
        if (prevTop != null) {
            AssertJUnit.assertFalse((String)("Topology is still the same: " + prevTop), (boolean)prevTop.equals(remoteCache.getCacheTopologyInfo().getTopologyId()));
        }
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer1);
        this.hotRodServer1 = null;
    }
}

