/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.admin;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.annotation.model.ModelA;
import org.infinispan.client.hotrod.annotation.model.ModelB;
import org.infinispan.client.hotrod.annotation.model.SchemaA;
import org.infinispan.client.hotrod.annotation.model.SchemaB;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.admin.SchemaIndexUpdateTest")
public class SchemaIndexUpdateTest
extends SingleHotRodServerTest {
    private static final String CACHE_NAME = "models";
    private final ProtoStreamMarshaller schemaEvolutionClientMarshaller = new ProtoStreamMarshaller();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.encoding().mediaType("application/x-protostream").indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("model.Model");
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createServerModeCacheManager();
        cacheManager.defineConfiguration(CACHE_NAME, builder.build());
        return cacheManager;
    }

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        return HotRodClientTestingUtil.startHotRodServer(this.cacheManager, serverBuilder);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host(host).port(serverPort).addContextInitializer((SerializationContextInitializer)SchemaA.INSTANCE).marshaller((Marshaller)this.schemaEvolutionClientMarshaller);
        return builder;
    }

    @Test
    public void test() {
        RemoteCache cache = this.remoteCacheManager.getCache(CACHE_NAME);
        cache.put((Object)1, (Object)new ModelA("Fabio"));
        Query query = Search.getQueryFactory((RemoteCache)cache).create("from model.Model where original is not null");
        List result = query.execute().list();
        Assertions.assertThat((List)result).extracting("original").containsExactly(new Object[]{"Fabio"});
        Assertions.assertThat((List)result).hasOnlyElementsOfType(ModelA.class);
        this.updateSchemaIndex();
        cache.put((Object)2, (Object)new ModelB("Silvia", "Silvia"));
        query = Search.getQueryFactory((RemoteCache)cache).create("from model.Model where original is not null");
        result = query.execute().list();
        Assertions.assertThat((List)result).extracting("original").containsExactly(new Object[]{"Fabio", "Silvia"});
        Assertions.assertThat((List)result).hasOnlyElementsOfType(ModelB.class);
        query = Search.getQueryFactory((RemoteCache)cache).create("from model.Model where different is not null");
        result = query.execute().list();
        Assertions.assertThat((List)result).extracting("different").containsExactly(new Object[]{"Silvia"});
        Assertions.assertThat((List)result).hasOnlyElementsOfType(ModelB.class);
    }

    private void updateSchemaIndex() {
        SchemaB schema = SchemaB.INSTANCE;
        schema.registerSchema(this.schemaEvolutionClientMarshaller.getSerializationContext());
        schema.registerMarshallers(this.schemaEvolutionClientMarshaller.getSerializationContext());
        RemoteCache metadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)schema.getProtoFileName(), (Object)schema.getProtoFile());
        this.remoteCacheManager.administration().updateIndexSchema(CACHE_NAME);
    }
}

