/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.query.TestSCIImpl;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.server.hotrod.HotRodServer;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.EvictionProtobufTest")
public class EvictionProtobufTest
extends MultiHotRodServersTest {
    private static final int NUM_SERVERS = 2;
    private static final String CACHE_NAME = "test";

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, new ConfigurationBuilder());
        ConfigurationBuilder builder = EvictionProtobufTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC);
        builder.encoding().mediaType("application/x-protostream");
        builder.expiration().wakeUpInterval(60000L);
        builder.memory().storage(StorageType.HEAP).maxSize("1000000000").whenFull(EvictionStrategy.REMOVE);
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntities(new String[]{"sample.Book"});
        for (HotRodServer server : this.servers) {
            server.getCacheManager().defineConfiguration(CACHE_NAME, builder.build());
            server.getCacheManager().getCache(CACHE_NAME);
        }
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestSCI.INSTANCE;
    }

    @Test
    public void testCacheInteraction() {
        RemoteCacheManager client = this.client(0);
        RemoteCache cache = client.getCache(CACHE_NAME);
        cache.put((Object)"100", (Object)new Book("Persepolis Rising", "James Corey", 2017));
        Assert.assertEquals((int)cache.size(), (int)1);
        cache.put((Object)"100", (Object)new Book("Nemesis Games", "James Corey", 2015));
        Assert.assertEquals((int)cache.size(), (int)1);
        cache.remove((Object)"100");
        Assert.assertEquals((int)cache.size(), (int)0);
    }

    @ProtoDoc(value="@Indexed")
    public static class Book {
        @ProtoDoc(value="@Field(index=Index.YES, analyze = Analyze.YES, store = Store.NO)")
        @ProtoField(number=1)
        final String title;
        @ProtoDoc(value="@Field(index=Index.YES, analyze = Analyze.YES, store = Store.NO)")
        @ProtoField(number=2)
        final String author;
        @ProtoDoc(value="@Field(index=Index.YES, analyze = Analyze.YES, store = Store.NO)")
        @ProtoField(number=3, defaultValue="0")
        final int publicationYear;

        @ProtoFactory
        public Book(String title, String author, int publicationYear) {
            this.title = title;
            this.author = author;
            this.publicationYear = publicationYear;
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={Book.class}, schemaFileName="test.EvictionProtobufTest.proto", schemaFilePath="proto/generated", schemaPackageName="sample")
    static interface TestSCI
    extends SerializationContextInitializer {
        public static final TestSCI INSTANCE = new TestSCIImpl();
    }
}

