/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.query.testdomain.protobuf.KeywordEntity;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.LargeTermTest")
public class LargeTermTest
extends SingleHotRodServerTest {
    public static final String DESCRIPTION = "foo bar% baz";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("KeywordEntity");
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager();
        manager.defineConfiguration("keyword", builder.build());
        return manager;
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return KeywordEntity.KeywordSchema.INSTANCE;
    }

    @Test
    public void test() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache("keyword");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> remoteCache.put((Object)1, (Object)new KeywordEntity(this.createLargeDescription(3000)))).isInstanceOf(HotRodClientException.class)).hasMessageContaining("bytes can be at most 32766");
        KeywordEntity entity = new KeywordEntity(this.createLargeDescription(1));
        remoteCache.put((Object)1, (Object)entity);
        QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)remoteCache);
        AssertJUnit.assertEquals((long)1L, (long)queryFactory.create("from KeywordEntity where keyword : 'foo bar0 baz'").execute().hitCount().orElse(-1L));
    }

    public String createLargeDescription(int times) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            String desc = DESCRIPTION.replace("%", "" + i);
            builder.append(desc);
            if (i >= times - 1) continue;
            builder.append(" ");
        }
        return builder.toString();
    }
}

