/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.tracing;

import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.model.Author;
import org.infinispan.client.hotrod.annotation.model.Poem;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.client.hotrod.tracing.OpenTelemetryClient;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.server.core.telemetry.TelemetryService;
import org.infinispan.server.core.telemetry.impl.OpenTelemetryService;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.tracing.TracingPropagationTest")
public class TracingPropagationTest
extends SingleHotRodServerTest {
    private final InMemorySpanExporter inMemorySpanExporter = InMemorySpanExporter.create();
    private final OpenTelemetryClient oTelConfig = new OpenTelemetryClient((SpanExporter)this.inMemorySpanExporter);

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("poem.Poem");
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager();
        manager.defineConfiguration("poems", builder.build());
        GlobalComponentRegistry globalComponentRegistry = manager.getGlobalComponentRegistry();
        globalComponentRegistry.registerComponent((Object)new OpenTelemetryService(this.oTelConfig.openTelemetry()), TelemetryService.class);
        return manager;
    }

    @Override
    protected void teardown() {
        this.oTelConfig.shutdown();
        super.teardown();
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return Poem.PoemSchema.INSTANCE;
    }

    @Test
    public void smokeTest() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache("poems");
        this.oTelConfig.withinClientSideSpan("user-client-side-span", () -> {
            Map<String, String> contextMap = TracingPropagationTest.getContextMap();
            Assertions.assertThat(contextMap).isNotEmpty();
            remoteCache.put((Object)1, (Object)new Poem(new Author("Edgar Allen Poe"), "The Raven", 1845));
            remoteCache.put((Object)2, (Object)new Poem(new Author("Emily Dickinson"), "Because I could not stop for Death", 1890));
        });
        List spans = this.inMemorySpanExporter.getFinishedSpanItems();
        Assertions.assertThat((List)spans).hasSize(3);
        String traceId = null;
        HashSet<String> spanIds = new HashSet<String>();
        HashMap<String, Integer> parentSpanIds = new HashMap<String, Integer>();
        String parentSpan = null;
        for (SpanData span : spans) {
            if (traceId == null) {
                traceId = span.getTraceId();
            } else {
                Assertions.assertThat((String)span.getTraceId()).isEqualTo((Object)traceId);
            }
            spanIds.add(span.getSpanId());
            parentSpanIds.compute(span.getParentSpanId(), (key, value) -> value == null ? 1 : value + 1);
            Integer times = (Integer)parentSpanIds.get(span.getParentSpanId());
            if (times != 2) continue;
            parentSpan = span.getParentSpanId();
        }
        Assertions.assertThat(spanIds).hasSize(3);
        Assertions.assertThat(parentSpanIds).hasSize(2);
        Assertions.assertThat(spanIds).contains(new Object[]{parentSpan});
    }

    public static Map<String, String> getContextMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        W3CTraceContextPropagator.getInstance().inject(Context.current(), result, (carrier, key, value) -> carrier.put(key, value));
        return result;
    }
}

