/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.transcoding;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.query.RemoteQueryTestUtils;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.client.hotrod.transcoding.ComplexKey;
import org.infinispan.client.hotrod.transcoding.ComplexValue;
import org.infinispan.client.hotrod.transcoding.JsonMarshaller;
import org.infinispan.client.hotrod.transcoding.SCIImpl;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.marshall.IdentityMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.testng.internal.junit.ArrayAsserts;

@Test(groups={"functional"}, testName="client.hotrod.transcoding.DataFormatTest")
public class DataFormatTest
extends SingleHotRodServerTest {
    private static final String CACHE_NAME = "test";
    private RemoteCache<Object, Object> remoteCache;

    protected ConfigurationBuilder buildCacheConfig() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.encoding().key().mediaType("application/x-protostream");
        builder.encoding().value().mediaType("application/x-protostream");
        return builder;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createServerModeCacheManager((SerializationContextInitializer)this.contextInitializer(), (ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.defineConfiguration(CACHE_NAME, HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)this.buildCacheConfig()).build());
        return this.cacheManager;
    }

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(this.cacheManager, new HotRodServerConfigurationBuilder());
        server.addCacheEventFilterFactory("static-filter-factory", new EventLogListener.StaticCacheEventFilterFactory<Integer>(42));
        server.addCacheEventFilterFactory("raw-static-filter-factory", (CacheEventFilterFactory)new EventLogListener.RawStaticCacheEventFilterFactory());
        return server;
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return SCI.INSTANCE;
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.remoteCache = this.remoteCacheManager.getCache(CACHE_NAME);
    }

    @Test
    public void testValueInMultipleFormats() throws Exception {
        this.remoteCache.clear();
        String quote = "I find your lack of faith disturbing";
        byte[] protostreamMarshalledQuote = this.marshall(quote);
        this.remoteCache.put((Object)1, (Object)quote);
        Object asBinary = this.remoteCache.withDataFormat(DataFormat.builder().valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build()).get((Object)1);
        ArrayAsserts.assertArrayEquals((byte[])protostreamMarshalledQuote, (byte[])((byte[])asBinary));
        Object asUTF8 = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.TEXT_PLAIN).valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build()).get((Object)1);
        ArrayAsserts.assertArrayEquals((byte[])quote.getBytes(StandardCharsets.UTF_8), (byte[])((byte[])asUTF8));
        Object asString = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.TEXT_PLAIN).build()).get((Object)1);
        AssertJUnit.assertEquals((Object)quote, (Object)asString);
        MetadataValue metadataValue = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.TEXT_PLAIN).build()).getWithMetadata((Object)1);
        AssertJUnit.assertEquals((Object)quote, (Object)metadataValue.getValue());
        Map allEntries = this.remoteCache.withDataFormat(DataFormat.builder().valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build()).getAll(new HashSet<Integer>(Collections.singletonList(1)));
        ArrayAsserts.assertArrayEquals((byte[])protostreamMarshalledQuote, (byte[])((byte[])allEntries.get(1)));
        Json expectedJson = Json.object((Object[])new Object[]{"_type", "string"}).set("_value", (Object)quote);
        Object asJSon = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JSON).build()).get((Object)1);
        AssertJUnit.assertEquals((Object)expectedJson, (Object)Json.read((String)new String((byte[])asJSon)));
        Json asJsonNode = (Json)this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new JsonMarshaller()).build()).get((Object)1);
        AssertJUnit.assertEquals((Object)expectedJson, (Object)asJsonNode);
        Object raw = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_PROTOSTREAM).valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build()).values().iterator().next();
        ArrayAsserts.assertArrayEquals((byte[])protostreamMarshalledQuote, (byte[])((byte[])raw));
        asJsonNode = (Json)this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new JsonMarshaller()).build()).values().iterator().next();
        AssertJUnit.assertEquals((Object)expectedJson, (Object)asJsonNode);
    }

    @Test
    public void testKeysInMultipleFormats() throws Exception {
        this.remoteCache.clear();
        String value = "infinispan.org:8080";
        this.remoteCache.put((Object)"1", (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.remoteCache.get((Object)"1"));
        this.remoteCache.withDataFormat(DataFormat.builder().keyType(MediaType.TEXT_PLAIN).keyMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build()).put((Object)"utf-key".getBytes(), (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.remoteCache.get((Object)"utf-key"));
        RemoteCache remoteCacheUTFKey = this.remoteCache.withDataFormat(DataFormat.builder().keyType(MediaType.TEXT_PLAIN).build());
        this.remoteCache.put((Object)"temp-key", (Object)value);
        Assert.assertTrue((boolean)remoteCacheUTFKey.containsKey((Object)"temp-key"));
        remoteCacheUTFKey.remove((Object)"temp-key");
        AssertJUnit.assertFalse((boolean)remoteCacheUTFKey.containsKey((Object)"temp-key"));
        AssertJUnit.assertEquals((Object)value, (Object)remoteCacheUTFKey.get((Object)"1"));
        Object asString = this.remoteCache.withDataFormat(DataFormat.builder().keyType(MediaType.TEXT_PLAIN).valueType(MediaType.TEXT_PLAIN).build()).get((Object)"1");
        AssertJUnit.assertEquals((Object)asString, (Object)"infinispan.org:8080");
        this.remoteCache.withDataFormat(DataFormat.builder().keyType(MediaType.APPLICATION_PROTOSTREAM).keyMarshaller((Marshaller)IdentityMarshaller.INSTANCE).valueType(MediaType.APPLICATION_PROTOSTREAM).valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build()).put((Object)this.marshall(1024), (Object)this.marshall(value));
        AssertJUnit.assertEquals((Object)value, (Object)this.remoteCache.get((Object)1024));
        boolean removed = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.TEXT_PLAIN).build()).remove((Object)1024, (Object)"wrong-address.com");
        AssertJUnit.assertFalse((boolean)removed);
        removed = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.TEXT_PLAIN).build()).remove((Object)1024, (Object)"infinispan.org:8080");
        Assert.assertTrue((boolean)removed);
        AssertJUnit.assertFalse((boolean)this.remoteCache.containsKey((Object)1024));
    }

    @Test
    public void testBatchOperations() {
        this.remoteCache.clear();
        HashMap entries = new HashMap();
        IntStream.range(0, 50).forEach(i -> {
            ComplexKey key = new ComplexKey(String.valueOf(i), Float.valueOf(i));
            ComplexValue value = new ComplexValue(Util.threadLocalRandomUUID());
            entries.put(key, value);
        });
        this.remoteCache.putAll(entries);
        RemoteCache jsonCache = this.remoteCache.withDataFormat(DataFormat.builder().keyType(MediaType.APPLICATION_JSON).keyMarshaller((Marshaller)new UTF8StringMarshaller()).build());
        HashSet jsonKeys = new HashSet(jsonCache.keySet());
        jsonKeys.forEach(k -> Assert.assertTrue((boolean)k.contains("\"_type\": \"org.infinispan.test.client.DataFormatTest.ComplexKey\"")));
        HashMap newEntries = new HashMap();
        IntStream.range(50, 100).forEach(i -> {
            Json key = Json.object((Object[])new Object[]{"_type", "org.infinispan.test.client.DataFormatTest.ComplexKey"}).set("id", (Object)i).set("ratio", (Object)i);
            Json value = Json.object((Object[])new Object[]{"_type", "org.infinispan.test.client.DataFormatTest.ComplexValue"}).set("uuid", (Object)Util.threadLocalRandomUUID().toString());
            newEntries.put(key.toString(), value.toString());
        });
        jsonCache.putAll(newEntries);
        HashSet keys = new HashSet();
        IntStream.range(60, 70).forEach(i -> keys.add(new ComplexKey(String.valueOf(i), Float.valueOf(i))));
        Set returned = this.remoteCache.getAll(keys).keySet().stream().map(ComplexKey.class::cast).collect(Collectors.toSet());
        AssertJUnit.assertEquals(keys, returned);
    }

    @Test
    public void testListenersWithDifferentFormats() {
        this.remoteCache.clear();
        ComplexKey complexKey = new ComplexKey("Key-1", Float.valueOf(89.88f));
        ComplexValue complexValue = new ComplexValue(Util.threadLocalRandomUUID());
        DataFormat jsonStringFormat = DataFormat.builder().keyType(MediaType.APPLICATION_JSON).keyMarshaller((Marshaller)new UTF8StringMarshaller()).build();
        EventLogListener l = new EventLogListener(this.remoteCache.withDataFormat(jsonStringFormat));
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            this.remoteCache.put((Object)complexKey, (Object)complexValue);
            l.expectOnlyCreatedEvent("\n{\n   \"_type\": \"org.infinispan.test.client.DataFormatTest.ComplexKey\",\n   \"id\": \"Key-1\",\n   \"ratio\": 89.88\n}\n");
        });
    }

    @Test
    public void testNonRawFilteredListeners() {
        this.remoteCache.clear();
        RemoteCache remoteCache = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.TEXT_PLAIN).build());
        EventLogListener.StaticFilteredEventLogListener l = new EventLogListener.StaticFilteredEventLogListener(remoteCache);
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            remoteCache.put((Object)1, (Object)"value1");
            l.expectNoEvents();
            remoteCache.put((Object)42, (Object)"value2");
            l.expectOnlyCreatedEvent(42);
        });
    }

    @Test
    public void testRawFilteredListeners() {
        this.remoteCache.clear();
        RemoteCache jsonCache = this.remoteCache.withDataFormat(DataFormat.builder().keyType(MediaType.APPLICATION_JSON).keyMarshaller((Marshaller)new UTF8StringMarshaller()).build());
        EventLogListener.RawStaticFilteredEventLogListener l = new EventLogListener.RawStaticFilteredEventLogListener(jsonCache);
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            jsonCache.put((Object)"{\"_type\":\"int32\",\"_value\":1}", (Object)Util.threadLocalRandomUUID().toString());
            l.expectNoEvents();
            jsonCache.put((Object)"{\"_type\":\"int32\",\"_value\":2}", (Object)Util.threadLocalRandomUUID().toString());
            l.expectOnlyCreatedEvent("\n{\n   \"_type\": \"int32\",\n   \"_value\": 2\n}\n");
        });
    }

    @Test
    public void testJsonFromDefaultCache() {
        RemoteCache schemaCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        schemaCache.put((Object)"schema.proto", (Object)"message M { optional string json_key = 1; }");
        RemoteQueryTestUtils.checkSchemaErrors((BasicCache<String, String>)schemaCache);
        DataFormat jsonValues = DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new UTF8StringMarshaller()).build();
        RemoteCache cache = this.remoteCacheManager.getCache().withDataFormat(jsonValues);
        String value = "{\"_type\":\"M\",\"json_key\":\"json_value\"}";
        cache.put((Object)1, (Object)value);
        String valueAsJson = (String)cache.get((Object)1);
        Json node = Json.read((String)valueAsJson);
        AssertJUnit.assertEquals((String)"json_value", (String)node.at("json_key").asString());
    }

    private byte[] marshall(Object o) throws Exception {
        return this.remoteCache.getRemoteCacheContainer().getMarshaller().objectToByteBuffer(o);
    }

    @AutoProtoSchemaBuilder(includeClasses={ComplexKey.class, ComplexValue.class}, schemaFileName="test.client.DataFormatTest.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.client.DataFormatTest")
    static interface SCI
    extends SerializationContextInitializer {
        public static final SCI INSTANCE = new SCIImpl();
    }
}

