/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.TransportFactory;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ClusterConfiguration;
import org.infinispan.client.hotrod.configuration.ClusterConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SecurityConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.configuration.ServerConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.StatisticsConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionConfigurationBuilder;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashV2;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.Features;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.SerializationContextInitializer;

public class ConfigurationBuilder
implements ConfigurationChildBuilder,
Builder<Configuration> {
    private static final Log log = LogFactory.getLog(ConfigurationBuilder.class, Log.class);
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(\\[([0-9A-Fa-f:]+)\\]|([^:/?#]*))(?::(\\d*))?");
    private static final int CACHE_PREFIX_LENGTH = "infinispan.client.hotrod.cache.".length();
    private WeakReference<ClassLoader> classLoader;
    private final ExecutorFactoryConfigurationBuilder asyncExecutorFactory;
    private Supplier<FailoverRequestBalancingStrategy> balancingStrategyFactory = RoundRobinBalancingStrategy::new;
    private ClientIntelligence clientIntelligence = ClientIntelligence.getDefault();
    private final ConnectionPoolConfigurationBuilder connectionPool;
    private int connectionTimeout = 60000;
    private final Class<? extends ConsistentHash>[] consistentHashImpl = new Class[]{null, ConsistentHashV2.class, SegmentConsistentHash.class};
    private boolean forceReturnValues;
    private int keySizeEstimate = 64;
    private Class<? extends Marshaller> marshallerClass;
    private Marshaller marshaller;
    private ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT_PROTOCOL_VERSION;
    private final List<ServerConfigurationBuilder> servers = new ArrayList<ServerConfigurationBuilder>();
    private int socketTimeout = 60000;
    private final SecurityConfigurationBuilder security;
    private boolean tcpNoDelay = true;
    private boolean tcpKeepAlive = false;
    private int valueSizeEstimate = 512;
    private int maxRetries = 10;
    private final NearCacheConfigurationBuilder nearCache;
    private final List<String> allowListRegExs = new ArrayList<String>();
    private int batchSize = 10000;
    private final TransactionConfigurationBuilder transaction;
    private final StatisticsConfigurationBuilder statistics;
    private final List<ClusterConfigurationBuilder> clusters = new ArrayList<ClusterConfigurationBuilder>();
    private Features features;
    private final List<SerializationContextInitializer> contextInitializers = new ArrayList<SerializationContextInitializer>();
    private final Map<String, RemoteCacheConfigurationBuilder> remoteCacheBuilders;
    private TransportFactory transportFactory = TransportFactory.DEFAULT;
    private boolean tracingPropagationEnabled = true;
    private int dnsResolverMinTTL = 0;
    private int dnsResolverMaxTTL = Integer.MAX_VALUE;
    private int dnsResolverNegativeTTL = 0;

    public ConfigurationBuilder() {
        this.classLoader = new WeakReference<ClassLoader>(Thread.currentThread().getContextClassLoader());
        this.connectionPool = new ConnectionPoolConfigurationBuilder(this);
        this.asyncExecutorFactory = new ExecutorFactoryConfigurationBuilder(this);
        this.security = new SecurityConfigurationBuilder(this);
        this.nearCache = new NearCacheConfigurationBuilder(this);
        this.transaction = new TransactionConfigurationBuilder(this);
        this.statistics = new StatisticsConfigurationBuilder(this);
        this.remoteCacheBuilders = new HashMap<String, RemoteCacheConfigurationBuilder>();
    }

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    @Override
    public ServerConfigurationBuilder addServer() {
        ServerConfigurationBuilder builder = new ServerConfigurationBuilder(this);
        this.servers.add(builder);
        return builder;
    }

    @Override
    public ClusterConfigurationBuilder addCluster(String clusterName) {
        ClusterConfigurationBuilder builder = new ClusterConfigurationBuilder(this, clusterName);
        this.clusters.add(builder);
        return builder;
    }

    @Override
    public ConfigurationBuilder addServers(String servers) {
        ConfigurationBuilder.parseServers(servers, (host, port) -> this.addServer().host((String)host).port((int)port));
        return this;
    }

    public List<ServerConfigurationBuilder> servers() {
        return this.servers;
    }

    public static void parseServers(String servers, BiConsumer<String, Integer> c) {
        for (String server : servers.split(";")) {
            Matcher matcher = ADDRESS_PATTERN.matcher(server.trim());
            if (!matcher.matches()) {
                throw Log.HOTROD.parseErrorServerAddress(server);
            }
            String v6host = matcher.group(2);
            String v4host = matcher.group(3);
            String host = v6host != null ? v6host : v4host;
            String portString = matcher.group(4);
            int port = portString == null ? 11222 : Integer.parseInt(portString);
            c.accept(host, port);
        }
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    @Override
    public ConfigurationBuilder balancingStrategy(String balancingStrategy) {
        this.balancingStrategyFactory = () -> (FailoverRequestBalancingStrategy)Util.getInstance((String)balancingStrategy, (ClassLoader)this.classLoader());
        return this;
    }

    @Override
    public ConfigurationBuilder balancingStrategy(Supplier<FailoverRequestBalancingStrategy> balancingStrategyFactory) {
        this.balancingStrategyFactory = balancingStrategyFactory;
        return this;
    }

    @Override
    public ConfigurationBuilder balancingStrategy(Class<? extends FailoverRequestBalancingStrategy> balancingStrategy) {
        this.balancingStrategyFactory = () -> (FailoverRequestBalancingStrategy)Util.getInstance((Class)balancingStrategy);
        return this;
    }

    @Override
    public ConfigurationBuilder classLoader(ClassLoader cl) {
        this.classLoader = new WeakReference<ClassLoader>(cl);
        return this;
    }

    ClassLoader classLoader() {
        return this.classLoader != null ? (ClassLoader)this.classLoader.get() : null;
    }

    @Override
    public ConfigurationBuilder clientIntelligence(ClientIntelligence clientIntelligence) {
        this.clientIntelligence = clientIntelligence;
        return this;
    }

    @Override
    public ConnectionPoolConfigurationBuilder connectionPool() {
        return this.connectionPool;
    }

    @Override
    public ConfigurationBuilder connectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Override
    public ConfigurationBuilder consistentHashImpl(int version, Class<? extends ConsistentHash> consistentHashClass) {
        if (version == 1) {
            log.warn("Hash function version 1 is no longer supported.");
        } else {
            this.consistentHashImpl[version - 1] = consistentHashClass;
        }
        return this;
    }

    @Override
    public ConfigurationBuilder consistentHashImpl(int version, String consistentHashClass) {
        if (version == 1) {
            log.warn("Hash function version 1 is no longer supported.");
        } else {
            this.consistentHashImpl[version - 1] = Util.loadClass((String)consistentHashClass, (ClassLoader)this.classLoader());
        }
        return this;
    }

    @Override
    public ConfigurationBuilder dnsResolverMinTTL(int minTTL) {
        this.dnsResolverMinTTL = minTTL;
        return this;
    }

    @Override
    public ConfigurationBuilder dnsResolverMaxTTL(int maxTTL) {
        this.dnsResolverMaxTTL = maxTTL;
        return this;
    }

    @Override
    public ConfigurationBuilder dnsResolverNegativeTTL(int negativeTTL) {
        this.dnsResolverNegativeTTL = negativeTTL;
        return this;
    }

    @Override
    public ConfigurationBuilder forceReturnValues(boolean forceReturnValues) {
        this.forceReturnValues = forceReturnValues;
        return this;
    }

    @Override
    @Deprecated
    public ConfigurationBuilder keySizeEstimate(int keySizeEstimate) {
        this.keySizeEstimate = keySizeEstimate;
        return this;
    }

    @Override
    public ConfigurationBuilder marshaller(String marshallerClassName) {
        return this.marshaller(marshallerClassName == null ? null : Util.loadClass((String)marshallerClassName, (ClassLoader)this.classLoader()));
    }

    @Override
    public ConfigurationBuilder marshaller(Class<? extends Marshaller> marshallerClass) {
        this.marshallerClass = marshallerClass;
        this.marshaller = marshallerClass == null ? null : (Marshaller)Util.getInstance(marshallerClass);
        return this;
    }

    @Override
    public ConfigurationBuilder marshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        this.marshallerClass = marshaller == null ? null : marshaller.getClass();
        return this;
    }

    @Override
    public ConfigurationBuilder addContextInitializer(String contextInitializer) {
        SerializationContextInitializer sci = (SerializationContextInitializer)Util.getInstance((String)contextInitializer, (ClassLoader)this.classLoader());
        return this.addContextInitializers(sci);
    }

    @Override
    public ConfigurationBuilder addContextInitializer(SerializationContextInitializer contextInitializer) {
        if (contextInitializer != null) {
            this.contextInitializers.add(contextInitializer);
        }
        return this;
    }

    @Override
    public ConfigurationBuilder addContextInitializers(SerializationContextInitializer ... contextInitializers) {
        this.contextInitializers.addAll(Arrays.asList(contextInitializers));
        return this;
    }

    @Deprecated
    public NearCacheConfigurationBuilder nearCache() {
        return this.nearCache;
    }

    @Override
    @Deprecated
    public ConfigurationBuilder protocolVersion(String protocolVersion) {
        this.protocolVersion = ProtocolVersion.parseVersion(protocolVersion);
        return this;
    }

    @Override
    public ConfigurationBuilder version(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        return this;
    }

    @Override
    public SecurityConfigurationBuilder security() {
        return this.security;
    }

    @Override
    public ConfigurationBuilder socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @Override
    public ConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    @Override
    public ConfigurationBuilder tcpKeepAlive(boolean keepAlive) {
        this.tcpKeepAlive = keepAlive;
        return this;
    }

    @Override
    public ConfigurationBuilder uri(URI uri) {
        return HotRodURI.create(uri).toConfigurationBuilder(this);
    }

    @Override
    public ConfigurationBuilder uri(String uri) {
        return this.uri(URI.create(uri));
    }

    @Override
    @Deprecated
    public ConfigurationBuilder valueSizeEstimate(int valueSizeEstimate) {
        this.valueSizeEstimate = valueSizeEstimate;
        return this;
    }

    @Override
    public ConfigurationBuilder maxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    @Override
    public ConfigurationBuilder addJavaSerialAllowList(String ... regEx) {
        this.allowListRegExs.addAll(Arrays.asList(regEx));
        return this;
    }

    @Override
    @Deprecated
    public ConfigurationBuilder addJavaSerialWhiteList(String ... regEx) {
        return this.addJavaSerialAllowList(regEx);
    }

    @Override
    public ConfigurationBuilder batchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be greater than 0");
        }
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public StatisticsConfigurationBuilder statistics() {
        return this.statistics;
    }

    @Override
    public TransactionConfigurationBuilder transaction() {
        return this.transaction;
    }

    @Override
    public RemoteCacheConfigurationBuilder remoteCache(String name) {
        return this.remoteCacheBuilders.computeIfAbsent(name, n -> new RemoteCacheConfigurationBuilder(this, (String)n));
    }

    @Override
    public ConfigurationBuilder transactionTimeout(long timeout, TimeUnit timeUnit) {
        this.transaction.timeout(timeout, timeUnit);
        return this;
    }

    @Override
    public ConfigurationBuilder transportFactory(TransportFactory transportFactory) {
        this.transportFactory = transportFactory;
        return this;
    }

    public ConfigurationBuilder disableTracingPropagation() {
        this.tracingPropagationEnabled = false;
        return this;
    }

    @Override
    public ConfigurationBuilder withProperties(Properties properties) {
        String serverList;
        TypedProperties typed = TypedProperties.toTypedProperties((Map)properties);
        if (typed.containsKey((Object)"infinispan.client.hotrod.uri")) {
            HotRodURI uri = HotRodURI.create(typed.getProperty("infinispan.client.hotrod.uri"));
            this.read(uri.toConfigurationBuilder().build());
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.async_executor_factory")) {
            this.asyncExecutorFactory().factoryClass(typed.getProperty("infinispan.client.hotrod.async_executor_factory", null, true));
        }
        this.asyncExecutorFactory().withExecutorProperties((Properties)typed);
        String balancingStrategyClass = typed.getProperty("infinispan.client.hotrod.request_balancing_strategy", null, true);
        if (balancingStrategyClass != null) {
            this.balancingStrategy(balancingStrategyClass);
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.client_intelligence")) {
            this.clientIntelligence((ClientIntelligence)typed.getEnumProperty("infinispan.client.hotrod.client_intelligence", ClientIntelligence.class, (Enum)ClientIntelligence.getDefault(), true));
        }
        this.connectionPool.withPoolProperties((Properties)typed);
        if (typed.containsKey((Object)"infinispan.client.hotrod.connect_timeout")) {
            this.connectionTimeout(typed.getIntProperty("infinispan.client.hotrod.connect_timeout", this.connectionTimeout, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.hash_function_impl.1")) {
            log.warn("Hash function version 1 is no longer supported");
        }
        for (int i = 0; i < this.consistentHashImpl.length; ++i) {
            int version;
            String hashClassName;
            if (this.consistentHashImpl[i] == null || (hashClassName = typed.getProperty("infinispan.client.hotrod.hash_function_impl." + (version = i + 1), null, true)) == null) continue;
            this.consistentHashImpl(version, hashClassName);
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.force_return_values")) {
            this.forceReturnValues(typed.getBooleanProperty("infinispan.client.hotrod.force_return_values", this.forceReturnValues, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.key_size_estimate")) {
            this.keySizeEstimate(typed.getIntProperty("infinispan.client.hotrod.key_size_estimate", this.keySizeEstimate, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.marshaller")) {
            this.marshaller(typed.getProperty("infinispan.client.hotrod.marshaller", null, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.context-initializers")) {
            String initializers = typed.getProperty("infinispan.client.hotrod.context-initializers");
            for (String sci : initializers.split(",")) {
                this.addContextInitializer(sci);
            }
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.protocol_version")) {
            this.version(ProtocolVersion.parseVersion(typed.getProperty("infinispan.client.hotrod.protocol_version", this.protocolVersion.toString(), true)));
        }
        if ((serverList = typed.getProperty("infinispan.client.hotrod.server_list", null, true)) != null) {
            this.servers.clear();
            this.addServers(serverList);
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.socket_timeout")) {
            this.socketTimeout(typed.getIntProperty("infinispan.client.hotrod.socket_timeout", this.socketTimeout, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.tcp_no_delay")) {
            this.tcpNoDelay(typed.getBooleanProperty("infinispan.client.hotrod.tcp_no_delay", this.tcpNoDelay, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.tcp_keep_alive")) {
            this.tcpKeepAlive(typed.getBooleanProperty("infinispan.client.hotrod.tcp_keep_alive", this.tcpKeepAlive, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.value_size_estimate")) {
            this.valueSizeEstimate(typed.getIntProperty("infinispan.client.hotrod.value_size_estimate", this.valueSizeEstimate, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.max_retries")) {
            this.maxRetries(typed.getIntProperty("infinispan.client.hotrod.max_retries", this.maxRetries, true));
        }
        if (typed.containsKey((Object)".dns_resolver_min_ttl")) {
            this.dnsResolverMinTTL(typed.getIntProperty(".dns_resolver_min_ttl", this.dnsResolverMinTTL, true));
        }
        if (typed.containsKey((Object)".dns_resolver_max_ttl")) {
            this.dnsResolverMaxTTL(typed.getIntProperty(".dns_resolver_max_ttl", this.dnsResolverMaxTTL, true));
        }
        if (typed.containsKey((Object)".dns_resolver_negative_ttl")) {
            this.dnsResolverNegativeTTL(typed.getIntProperty(".dns_resolver_negative_ttl", this.dnsResolverNegativeTTL, true));
        }
        this.security.ssl().withProperties(properties);
        this.security.authentication().withProperties(properties);
        String serialAllowList = typed.getProperty("infinispan.client.hotrod.java_serial_whitelist");
        if (serialAllowList != null && !serialAllowList.isEmpty()) {
            org.infinispan.commons.logging.Log.CONFIG.deprecatedProperty("infinispan.client.hotrod.java_serial_whitelist", "infinispan.client.hotrod.java_serial_allowlist");
            String[] classes = serialAllowList.split(",");
            Collections.addAll(this.allowListRegExs, classes);
        }
        if ((serialAllowList = typed.getProperty("infinispan.client.hotrod.java_serial_allowlist")) != null && !serialAllowList.isEmpty()) {
            String[] classes = serialAllowList.split(",");
            Collections.addAll(this.allowListRegExs, classes);
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.batch_size")) {
            this.batchSize(typed.getIntProperty("infinispan.client.hotrod.batch_size", this.batchSize, true));
        }
        this.transaction.withTransactionProperties((Properties)typed);
        this.nearCache.withProperties(properties);
        this.parseClusterProperties(typed);
        Set cachesNames = typed.keySet().stream().map(k -> (String)k).filter(k -> k.startsWith("infinispan.client.hotrod.cache.")).map(k -> k.charAt(CACHE_PREFIX_LENGTH) == '[' ? k.substring(CACHE_PREFIX_LENGTH + 1, k.indexOf(93, CACHE_PREFIX_LENGTH)) : k.substring(CACHE_PREFIX_LENGTH, k.indexOf(46, CACHE_PREFIX_LENGTH + 1))).collect(Collectors.toSet());
        for (String cacheName : cachesNames) {
            this.remoteCache(cacheName).withProperties((Properties)typed);
        }
        this.statistics.withProperties(properties);
        if (typed.containsKey((Object)"infinispan.client.hotrod.transport_factory")) {
            this.transportFactory = (TransportFactory)Util.getInstance((String)typed.getProperty("infinispan.client.hotrod.transport_factory"), (ClassLoader)((ClassLoader)this.classLoader.get()));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.tracing.propagation_enabled")) {
            this.tracingPropagationEnabled = typed.getBooleanProperty("infinispan.client.hotrod.tracing.propagation_enabled", true);
        }
        return this;
    }

    private void parseClusterProperties(TypedProperties properties) {
        HashMap builders = new HashMap();
        properties.forEach((k, v) -> {
            assert (k instanceof String);
            String key = (String)k;
            if (!key.startsWith("infinispan.client.hotrod.cluster")) {
                return;
            }
            assert (v instanceof String);
            String value = (String)v;
            Matcher intelligenceMatcher = ConfigurationProperties.CLUSTER_PROPERTIES_PREFIX_INTELLIGENCE_REGEX.matcher(key);
            if (intelligenceMatcher.matches()) {
                String clusterName = intelligenceMatcher.replaceFirst("");
                builders.computeIfAbsent(clusterName, this::addCluster).clusterClientIntelligence(ClientIntelligence.valueOf(value.toUpperCase()));
                return;
            }
            String clusterName = ConfigurationProperties.CLUSTER_PROPERTIES_PREFIX_REGEX.matcher(key).replaceFirst("");
            ClusterConfigurationBuilder builder = builders.computeIfAbsent(clusterName, this::addCluster);
            ConfigurationBuilder.parseServers(StringPropertyReplacer.replaceProperties((String)value), builder::addClusterNode);
        });
    }

    public void validate() {
        this.connectionPool.validate();
        this.asyncExecutorFactory.validate();
        this.security.validate();
        this.nearCache.validate();
        this.transaction.validate();
        this.statistics.validate();
        if (this.maxRetries < 0) {
            throw Log.HOTROD.invalidMaxRetries(this.maxRetries);
        }
        HashSet<String> clusterNameSet = new HashSet<String>(this.clusters.size());
        for (ClusterConfigurationBuilder clusterConfigBuilder : this.clusters) {
            if (!clusterNameSet.add(clusterConfigBuilder.getClusterName())) {
                throw Log.HOTROD.duplicateClusterDefinition(clusterConfigBuilder.getClusterName());
            }
            clusterConfigBuilder.validate();
        }
    }

    public Configuration create() {
        Class<Object> buildMarshallerClass;
        ArrayList<ServerConfiguration> servers = new ArrayList<ServerConfiguration>();
        if (this.servers.size() > 0) {
            for (ServerConfigurationBuilder server : this.servers) {
                servers.add(server.create());
            }
        } else {
            servers.add(new ServerConfiguration("127.0.0.1", 11222));
        }
        List<ClusterConfiguration> serverClusterConfigs = this.clusters.stream().map(ClusterConfigurationBuilder::create).collect(Collectors.toList());
        Marshaller buildMarshaller = this.marshaller;
        if (buildMarshaller == null && this.marshallerClass == null) {
            buildMarshaller = this.handleNullMarshaller();
        }
        if ((buildMarshallerClass = this.marshallerClass) == null) {
            buildMarshallerClass = buildMarshaller.getClass();
        } else if (buildMarshaller != null && !buildMarshallerClass.isInstance(buildMarshaller)) {
            throw new IllegalArgumentException("Both marshaller and marshallerClass attributes are present, but marshaller is not an instance of marshallerClass");
        }
        Map<String, RemoteCacheConfiguration> remoteCaches = this.remoteCacheBuilders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RemoteCacheConfigurationBuilder)e.getValue()).create()));
        return new Configuration(this.asyncExecutorFactory.create(), this.balancingStrategyFactory, this.classLoader == null ? null : (ClassLoader)this.classLoader.get(), this.clientIntelligence, this.connectionPool.create(), this.connectionTimeout, this.consistentHashImpl, this.dnsResolverMinTTL, this.dnsResolverMaxTTL, this.dnsResolverNegativeTTL, this.forceReturnValues, this.keySizeEstimate, buildMarshaller, buildMarshallerClass, this.protocolVersion, servers, this.socketTimeout, this.security.create(), this.tcpNoDelay, this.tcpKeepAlive, this.valueSizeEstimate, this.maxRetries, this.nearCache.create(), serverClusterConfigs, this.allowListRegExs, this.batchSize, this.transaction.create(), this.statistics.create(), this.features, this.contextInitializers, remoteCaches, this.transportFactory, this.tracingPropagationEnabled);
    }

    private Marshaller handleNullMarshaller() {
        return new ProtoStreamMarshaller();
    }

    @Override
    public Configuration build() {
        this.features = new Features((ClassLoader)this.classLoader.get());
        return this.build(true);
    }

    public Configuration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public ConfigurationBuilder read(Configuration template, Combine combine) {
        this.classLoader = new WeakReference<ClassLoader>(template.classLoader());
        this.asyncExecutorFactory.read(template.asyncExecutorFactory(), combine);
        this.balancingStrategyFactory = template.balancingStrategyFactory();
        this.connectionPool.read(template.connectionPool(), combine);
        this.connectionTimeout = template.connectionTimeout();
        for (int i = 0; i < this.consistentHashImpl.length; ++i) {
            this.consistentHashImpl[i] = template.consistentHashImpl(i + 1);
        }
        this.dnsResolverMinTTL = template.dnsResolverMinTTL();
        this.dnsResolverMaxTTL = template.dnsResolverMaxTTL();
        this.dnsResolverNegativeTTL = template.dnsResolverNegativeTTL();
        this.forceReturnValues = template.forceReturnValues();
        this.keySizeEstimate = template.keySizeEstimate();
        this.marshaller = template.marshaller();
        this.marshallerClass = template.marshallerClass();
        this.protocolVersion = template.version();
        this.servers.clear();
        for (ServerConfiguration server : template.servers()) {
            this.addServer().host(server.host()).port(server.port());
        }
        this.clusters.clear();
        template.clusters().forEach(cluster -> this.addCluster(cluster.getClusterName()).read((ClusterConfiguration)cluster, combine));
        this.socketTimeout = template.socketTimeout();
        this.security.read(template.security(), combine);
        this.tcpNoDelay = template.tcpNoDelay();
        this.tcpKeepAlive = template.tcpKeepAlive();
        this.transportFactory = template.transportFactory();
        this.valueSizeEstimate = template.valueSizeEstimate();
        this.maxRetries = template.maxRetries();
        this.nearCache.read(template.nearCache(), combine);
        this.allowListRegExs.addAll(template.serialWhitelist());
        this.transaction.read(template.transaction(), combine);
        this.statistics.read(template.statistics(), combine);
        this.contextInitializers.clear();
        this.contextInitializers.addAll(template.getContextInitializers());
        this.clientIntelligence = template.clientIntelligence();
        return this;
    }
}

