/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.impl;

import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.operation.AddListenerOperation;
import org.infinispan.client.hotrod.counter.operation.AddOperation;
import org.infinispan.client.hotrod.counter.operation.CompareAndSwapOperation;
import org.infinispan.client.hotrod.counter.operation.DefineCounterOperation;
import org.infinispan.client.hotrod.counter.operation.GetConfigurationOperation;
import org.infinispan.client.hotrod.counter.operation.GetCounterNamesOperation;
import org.infinispan.client.hotrod.counter.operation.GetValueOperation;
import org.infinispan.client.hotrod.counter.operation.IsDefinedOperation;
import org.infinispan.client.hotrod.counter.operation.RemoveListenerOperation;
import org.infinispan.client.hotrod.counter.operation.RemoveOperation;
import org.infinispan.client.hotrod.counter.operation.ResetOperation;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.counter.api.CounterConfiguration;

public class CounterOperationFactory {
    public static final byte[] COUNTER_CACHE_NAME = RemoteCacheManager.cacheNameBytes("org.infinispan.COUNTER");
    private final Configuration configuration;
    private final ChannelFactory channelFactory;
    private final AtomicReference<ClientTopology> clientTopologyRef;

    CounterOperationFactory(Configuration configuration, ChannelFactory channelFactory) {
        this.configuration = configuration;
        this.channelFactory = channelFactory;
        this.clientTopologyRef = channelFactory.createTopologyId(COUNTER_CACHE_NAME);
    }

    IsDefinedOperation newIsDefinedOperation(String counterName) {
        return new IsDefinedOperation(this.channelFactory, this.clientTopologyRef, this.configuration, counterName);
    }

    GetConfigurationOperation newGetConfigurationOperation(String counterName) {
        return new GetConfigurationOperation(this.channelFactory, this.clientTopologyRef, this.configuration, counterName);
    }

    DefineCounterOperation newDefineCounterOperation(String counterName, CounterConfiguration cfg) {
        return new DefineCounterOperation(this.channelFactory, this.clientTopologyRef, this.configuration, counterName, cfg);
    }

    RemoveOperation newRemoveOperation(String counterName, boolean useConsistentHash) {
        return new RemoveOperation(this.channelFactory, this.clientTopologyRef, this.configuration, counterName, useConsistentHash);
    }

    AddOperation newAddOperation(String counterName, long delta, boolean useConsistentHash) {
        return new AddOperation(this.channelFactory, this.clientTopologyRef, this.configuration, counterName, delta, useConsistentHash);
    }

    GetValueOperation newGetValueOperation(String counterName, boolean useConsistentHash) {
        return new GetValueOperation(this.channelFactory, this.clientTopologyRef, this.configuration, counterName, useConsistentHash);
    }

    ResetOperation newResetOperation(String counterName, boolean useConsistentHash) {
        return new ResetOperation(this.channelFactory, this.clientTopologyRef, this.configuration, counterName, useConsistentHash);
    }

    CompareAndSwapOperation newCompareAndSwapOperation(String counterName, long expect, long update, CounterConfiguration counterConfiguration) {
        return new CompareAndSwapOperation(this.channelFactory, this.clientTopologyRef, this.configuration, counterName, expect, update, counterConfiguration);
    }

    GetCounterNamesOperation newGetCounterNamesOperation() {
        return new GetCounterNamesOperation(this.channelFactory, this.clientTopologyRef, this.configuration);
    }

    AddListenerOperation newAddListenerOperation(String counterName, byte[] listenerId, SocketAddress server) {
        return new AddListenerOperation(this.channelFactory, this.clientTopologyRef, this.configuration, counterName, listenerId, server);
    }

    RemoveListenerOperation newRemoveListenerOperation(String counterName, byte[] listenerId, SocketAddress server) {
        return new RemoveListenerOperation(this.channelFactory, this.clientTopologyRef, this.configuration, counterName, listenerId, server);
    }
}

