/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.topology;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.impl.CacheTopologyInfoImpl;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.IntSets;

public class CacheInfo {
    private final String cacheName;
    private final int topologyAge;
    private final FailoverRequestBalancingStrategy balancer;
    private final int numSegments;
    private final List<InetSocketAddress> servers;
    private final Map<SocketAddress, Set<Integer>> primarySegments;
    private final ConsistentHash consistentHash;
    private final AtomicReference<ClientTopology> clientTopologyRef;
    private final ClientTopology clientTopology;

    public CacheInfo(WrappedBytes cacheName, FailoverRequestBalancingStrategy balancer, int topologyAge, List<InetSocketAddress> servers, ClientIntelligence intelligence) {
        this.balancer = balancer;
        this.topologyAge = topologyAge;
        this.cacheName = cacheName == null || cacheName.getLength() == 0 ? "<default>" : new String(cacheName.getBytes(), HotRodConstants.HOTROD_STRING_CHARSET);
        this.numSegments = -1;
        this.clientTopology = new ClientTopology(-1, intelligence);
        this.consistentHash = null;
        this.servers = Immutables.immutableListCopy(servers);
        this.primarySegments = null;
        this.clientTopologyRef = new AtomicReference<ClientTopology>(this.clientTopology);
    }

    public void updateBalancerServers() {
        this.balancer.setServers(this.servers);
    }

    public CacheInfo withNewServers(int topologyAge, int topologyId, List<InetSocketAddress> servers) {
        return this.withNewServers(topologyAge, topologyId, servers, this.clientTopologyRef.get().getClientIntelligence());
    }

    public CacheInfo withNewServers(int topologyAge, int topologyId, List<InetSocketAddress> servers, ClientIntelligence intelligence) {
        return new CacheInfo(this.cacheName, this.balancer, topologyAge, servers, null, -1, this.clientTopologyRef, new ClientTopology(topologyId, intelligence));
    }

    public CacheInfo withNewHash(int topologyAge, int topologyId, List<InetSocketAddress> servers, ConsistentHash consistentHash, int numSegments) {
        return new CacheInfo(this.cacheName, this.balancer, topologyAge, servers, consistentHash, numSegments, this.clientTopologyRef, new ClientTopology(topologyId, this.getIntelligence()));
    }

    private CacheInfo(String cacheName, FailoverRequestBalancingStrategy balancer, int topologyAge, List<InetSocketAddress> servers, ConsistentHash consistentHash, int numSegments, AtomicReference<ClientTopology> clientTopologyRef, ClientTopology clientTopology) {
        this.balancer = balancer;
        this.topologyAge = topologyAge;
        this.cacheName = cacheName;
        this.numSegments = numSegments;
        this.consistentHash = consistentHash;
        this.clientTopology = clientTopology;
        this.clientTopologyRef = clientTopologyRef;
        this.servers = Immutables.immutableListCopy(servers);
        this.primarySegments = numSegments > 0 ? consistentHash.getPrimarySegmentsByServer() : null;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public int getTopologyAge() {
        return this.topologyAge;
    }

    public FailoverRequestBalancingStrategy getBalancer() {
        return this.balancer;
    }

    public int getNumSegments() {
        return this.numSegments;
    }

    public int getTopologyId() {
        return this.clientTopology.getTopologyId();
    }

    public AtomicReference<ClientTopology> getClientTopologyRef() {
        return this.clientTopologyRef;
    }

    public List<InetSocketAddress> getServers() {
        return this.servers;
    }

    public Map<SocketAddress, Set<Integer>> getPrimarySegments() {
        if (this.primarySegments == null) {
            return Collections.emptyMap();
        }
        return this.primarySegments;
    }

    public ConsistentHash getConsistentHash() {
        return this.consistentHash;
    }

    public CacheTopologyInfo getCacheTopologyInfo() {
        Map<SocketAddress, Set<Integer>> segmentsByServer;
        if (this.consistentHash != null) {
            segmentsByServer = this.consistentHash.getSegmentsByServer();
        } else {
            segmentsByServer = new HashMap<SocketAddress, Set<Integer>>(this.servers.size());
            for (InetSocketAddress server : this.servers) {
                segmentsByServer.put(server, (Set<Integer>)IntSets.immutableEmptySet());
            }
        }
        return new CacheTopologyInfoImpl(segmentsByServer, this.numSegments > 0 ? Integer.valueOf(this.numSegments) : null, this.getTopologyId());
    }

    private ClientIntelligence getIntelligence() {
        return this.clientTopology.getClientIntelligence();
    }

    public void updateClientTopologyRef() {
        this.clientTopologyRef.set(this.clientTopology);
    }
}

