/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Map;
import org.infinispan.client.hotrod.AuthenticationTest;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.security.sasl.SaslAuthenticator;
import org.infinispan.server.core.security.simple.SimpleSaslAuthenticator;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;

@CleanupAfterTest
public abstract class AbstractAuthenticationTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(AuthenticationTest.class);
    protected RemoteCacheManager remoteCacheManager;
    protected HotRodServer hotrodServer;

    protected abstract EmbeddedCacheManager createCacheManager() throws Exception;

    protected abstract SimpleSaslAuthenticator createAuthenticationProvider();

    protected HotRodServer initServer(Map<String, String> mechProperties, int index) {
        HotRodServerConfigurationBuilder serverBuilder = HotRodTestingUtil.getDefaultHotRodConfiguration();
        serverBuilder.authentication().enable().sasl().serverName("localhost").addAllowedMech("CRAM-MD5").authenticator((SaslAuthenticator)this.createAuthenticationProvider());
        serverBuilder.authentication().sasl().mechProperties(mechProperties);
        int port = HotRodTestingUtil.serverPort() + index;
        HotRodServer server = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (int)port, (HotRodServerConfigurationBuilder)serverBuilder);
        log.info((Object)("Started server on port: " + server.getPort()));
        return server;
    }

    protected ConfigurationBuilder newClientBuilder() {
        return this.newClientBuilder(0);
    }

    protected ConfigurationBuilder newClientBuilder(int index) {
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host(this.hotrodServer.getHost()).port(this.hotrodServer.getPort().intValue()).socketTimeout(3000).maxRetries(3).connectionPool().maxActive(1).security().authentication().enable().saslMechanism("CRAM-MD5").connectionPool().maxActive(1);
        return clientBuilder;
    }

    protected void teardown() {
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        this.hotrodServer = null;
        super.teardown();
    }

    @AfterMethod(alwaysRun=true)
    protected void destroyAfterMethod() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)this.remoteCacheManager);
        this.remoteCacheManager = null;
        super.destroyAfterMethod();
    }
}

