/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.util.Random;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.AsymmetricRoutingTest")
public class AsymmetricRoutingTest
extends HitsAwareCacheManagersTest {
    private static final String DIST_ONE_CACHE_NAME = "dist-one-cache";
    private static final String DIST_TWO_CACHE_NAME = "dist-two-cache";
    HotRodServer server1;
    HotRodServer server2;
    org.infinispan.configuration.cache.ConfigurationBuilder defaultBuilder;
    org.infinispan.configuration.cache.ConfigurationBuilder distOneBuilder;
    org.infinispan.configuration.cache.ConfigurationBuilder distTwoBuilder;
    RemoteCacheManager rcm;

    protected org.infinispan.configuration.cache.ConfigurationBuilder defaultCacheConfigurationBuilder() {
        return HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)AsymmetricRoutingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC));
    }

    protected void createCacheManagers() throws Throwable {
        this.defaultBuilder = this.defaultCacheConfigurationBuilder();
        this.distOneBuilder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)AsymmetricRoutingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC));
        this.distOneBuilder.clustering().hash().numOwners(1).numSegments(1).consistentHashFactory((ConsistentHashFactory)new ControlledConsistentHashFactory.Default(0, new int[0]));
        this.distTwoBuilder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)AsymmetricRoutingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC));
        this.distTwoBuilder.clustering().hash().numOwners(1).numSegments(1).consistentHashFactory((ConsistentHashFactory)new ControlledConsistentHashFactory.Default(1, new int[0]));
        this.server1 = this.addHotRodServer();
        this.server2 = this.addHotRodServer();
        TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)2);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(0).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(1).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host(this.server1.getHost()).port(this.server1.getPort().intValue()).addServer().host(this.server2.getHost()).port(this.server2.getPort().intValue());
        this.rcm = new RemoteCacheManager(clientBuilder.build());
    }

    @Override
    @AfterClass
    protected void destroy() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)this.rcm);
        HotRodClientTestingUtil.killServers(this.server1, this.server2);
        this.server1 = null;
        this.server2 = null;
        super.destroy();
    }

    private HotRodServer addHotRodServer() {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(this.defaultBuilder);
        cm.defineConfiguration(DIST_ONE_CACHE_NAME, this.distOneBuilder.build());
        cm.defineConfiguration(DIST_TWO_CACHE_NAME, this.distTwoBuilder.build());
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(cm);
        this.addr2hrServer.put(new InetSocketAddress(server.getHost(), (int)server.getPort()), server);
        return server;
    }

    public void testRequestRouting() {
        this.addInterceptors(DIST_ONE_CACHE_NAME);
        this.addInterceptors(DIST_TWO_CACHE_NAME);
        byte[] keyDistOne = this.getKeyForServer(this.server1, DIST_ONE_CACHE_NAME);
        byte[] keyDistTwo = this.getKeyForServer(this.server2, DIST_TWO_CACHE_NAME);
        this.assertSegments(DIST_ONE_CACHE_NAME, this.server1, this.server1.getCacheManager().getAddress());
        this.assertSegments(DIST_ONE_CACHE_NAME, this.server2, this.server1.getCacheManager().getAddress());
        this.assertSegments(DIST_TWO_CACHE_NAME, this.server1, this.server2.getCacheManager().getAddress());
        this.assertSegments(DIST_TWO_CACHE_NAME, this.server2, this.server2.getCacheManager().getAddress());
        this.assertRequestRouting(keyDistOne, DIST_ONE_CACHE_NAME, this.server1);
        this.assertRequestRouting(keyDistTwo, DIST_TWO_CACHE_NAME, this.server2);
    }

    private void assertSegments(String cacheName, HotRodServer server, Address owner) {
        AdvancedCache cache = server.getCacheManager().getCache(cacheName).getAdvancedCache();
        ConsistentHash ch = cache.getDistributionManager().getReadConsistentHash();
        AssertJUnit.assertEquals((int)1, (int)ch.getNumSegments());
        Set segments = ch.getSegmentsForOwner(owner);
        AssertJUnit.assertEquals((int)1, (int)segments.size());
        AssertJUnit.assertEquals((int)0, (int)((Integer)segments.iterator().next()));
    }

    private void assertRequestRouting(byte[] key, String cacheName, HotRodServer server) {
        RemoteCache rcOne = this.rcm.getCache(cacheName);
        InetSocketAddress serverAddress = new InetSocketAddress(server.getHost(), (int)server.getPort());
        for (int i = 0; i < 2; ++i) {
            log.infof("Routing put test for key %s", (Object)Util.printArray((byte[])key, (boolean)false));
            rcOne.put((Object)key, (Object)"value");
            this.assertServerHit(serverAddress, cacheName, i + 1);
        }
    }

    byte[] getKeyForServer(HotRodServer primaryOwner, String cacheName) {
        Cache cache = primaryOwner.getCacheManager().getCache(cacheName);
        Random r = new Random();
        byte[] dummy = new byte[8];
        int attemptsLeft = 1000;
        do {
            r.nextBytes(dummy);
        } while (!DistributionTestHelper.isFirstOwner((Cache)cache, (Object)dummy) && --attemptsLeft >= 0);
        if (attemptsLeft < 0) {
            throw new IllegalStateException("Could not find any key owned by " + String.valueOf(primaryOwner));
        }
        log.infof("Binary key %s hashes to [cluster=%s,hotrod=%s]", (Object)Util.printArray((byte[])dummy, (boolean)false), (Object)primaryOwner.getCacheManager().getAddress(), (Object)primaryOwner.getAddress());
        return dummy;
    }
}

