/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.SomeCustomConsistentHashV2;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.consistenthash.CRC16ConsistentHashV2;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashFactory;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashV2;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ConsistentHashFactoryTest", groups={"functional"})
public class ConsistentHashFactoryTest
extends AbstractInfinispanTest {
    public void testPropertyCorrectlyRead() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.consistentHashImpl(2, SomeCustomConsistentHashV2.class);
        ConsistentHashFactory chf = new ConsistentHashFactory();
        chf.init(builder.build());
        ConsistentHash hash = chf.newConsistentHash(2);
        AssertJUnit.assertNotNull((Object)hash);
        AssertJUnit.assertEquals((Object)hash.getClass(), SomeCustomConsistentHashV2.class);
    }

    public void testNoChDefined() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        ConsistentHashFactory chf = new ConsistentHashFactory();
        chf.init(builder.build());
        ConsistentHash hash = chf.newConsistentHash(2);
        AssertJUnit.assertNotNull((Object)hash);
        AssertJUnit.assertEquals((Object)hash.getClass(), ConsistentHashV2.class);
    }

    public void testCRC16HashDefined() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.consistentHashImpl(2, CRC16ConsistentHashV2.class);
        ConsistentHashFactory chf = new ConsistentHashFactory();
        chf.init(builder.build());
        ConsistentHash hash = chf.newConsistentHash(2);
        AssertJUnit.assertNotNull((Object)hash);
        AssertJUnit.assertEquals((Object)hash.getClass(), CRC16ConsistentHashV2.class);
    }
}

