/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashV2;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.util.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="client.hotrod.ConsistentHashV2Test")
public class ConsistentHashV2Test {
    private InetSocketAddress a1;
    private InetSocketAddress a2;
    private InetSocketAddress a3;
    private InetSocketAddress a4;
    private DummyHash hash;
    private ConsistentHashV2 v1;

    private void setUp(int numOwners) {
        this.a1 = new InetSocketAddress(1);
        this.a2 = new InetSocketAddress(2);
        this.a3 = new InetSocketAddress(3);
        this.a4 = new InetSocketAddress(4);
        LinkedHashMap<InetSocketAddress, Set<Integer>> map = new LinkedHashMap<InetSocketAddress, Set<Integer>>();
        map.put(this.a1, Collections.singleton(0));
        map.put(this.a2, Collections.singleton(1000));
        map.put(this.a3, Collections.singleton(2000));
        map.put(this.a4, Collections.singleton(3000));
        this.hash = new DummyHash();
        this.v1 = new ConsistentHashV2(new Random(), (Hash)this.hash);
        this.v1.init(map, numOwners, 10000);
    }

    public void simpleTest() {
        this.setUp(1);
        this.hash.value = 0;
        assert (this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY).equals(this.a1));
        this.hash.value = 1;
        assert (this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY).equals(this.a2));
        this.hash.value = 1001;
        assert (this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY).equals(this.a3));
        this.hash.value = 2001;
        Assert.assertEquals((Object)this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY), (Object)this.a4);
        this.hash.value = 3001;
        assert (this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY).equals(this.a1));
    }

    public void numOwners2Test() {
        this.setUp(2);
        this.hash.value = 0;
        assert (this.list(this.a1, this.a2).contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
        this.hash.value = 1;
        assert (this.list(this.a2, this.a3).contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
        this.hash.value = 1001;
        assert (this.list(this.a3, this.a4).contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
        this.hash.value = 2001;
        assert (this.list(this.a4, this.a1).contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
        this.hash.value = 3001;
        assert (this.list(this.a1, this.a2).contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
    }

    public void numOwners3Test() {
        this.setUp(3);
        this.hash.value = 0;
        assert (this.list(this.a1, this.a2, this.a3).contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
        this.hash.value = 1;
        assert (this.list(this.a2, this.a3, this.a4).contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
        this.hash.value = 1001;
        assert (this.list(this.a3, this.a4, this.a1).contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
        this.hash.value = 2001;
        assert (this.list(this.a4, this.a1, this.a2).contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
        this.hash.value = 3001;
        assert (this.list(this.a1, this.a2, this.a3).contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
    }

    public void numOwners4Test() {
        this.setUp(4);
        List<InetSocketAddress> list = this.list(this.a1, this.a2, this.a3, this.a4);
        this.hash.value = 0;
        assert (list.contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
        this.hash.value = 1;
        assert (list.contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
        this.hash.value = 1001;
        assert (list.contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
        this.hash.value = 2001;
        assert (list.contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
        this.hash.value = 3001;
        assert (list.contains(this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY)));
    }

    private List<InetSocketAddress> list(InetSocketAddress ... a) {
        return Arrays.asList(a);
    }

    public void testCorrectHash() {
        this.hash.value = 1;
        this.v1.getServer((Object)Util.EMPTY_BYTE_ARRAY);
    }

    public static class DummyHash
    implements Hash {
        public int value;

        public int hash(byte[] payload) {
            return this.value;
        }

        public int hash(int hashcode) {
            return this.value;
        }

        public int hash(Object o) {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DummyHash dummyHash = (DummyHash)o;
            return this.value == dummyHash.value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

