/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;

public abstract class HitsAwareCacheManagersTest
extends MultipleCacheManagersTest {
    protected Map<SocketAddress, HotRodServer> addr2hrServer = new LinkedHashMap<SocketAddress, HotRodServer>();
    protected List<RemoteCacheManager> clients = new ArrayList<RemoteCacheManager>();

    protected void createHotRodServers(int num, org.infinispan.configuration.cache.ConfigurationBuilder defaultBuilder) {
        int i;
        for (i = 0; i < num; ++i) {
            this.addHotRodServer(defaultBuilder);
        }
        for (i = 0; i < num; ++i) {
            assert (this.manager(i).getCache() != null);
        }
        TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)num);
        for (i = 0; i < num; ++i) {
            TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(i).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        }
        this.addInterceptors();
        for (i = 0; i < num; ++i) {
            this.clients.add(this.createClient());
        }
    }

    protected RemoteCacheManager client(int i) {
        return this.clients.get(i);
    }

    protected RemoteCacheManager createClient() {
        return new RemoteCacheManager(this.createHotRodClientConfigurationBuilder(this.addr2hrServer.values().iterator().next().getPort()).build());
    }

    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(serverPort);
        clientBuilder.maxRetries(2);
        return clientBuilder;
    }

    protected HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(cm);
        InetSocketAddress addr = new InetSocketAddress(server.getHost(), (int)server.getPort());
        this.addr2hrServer.put(addr, server);
        return server;
    }

    protected HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder, int port) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        HotRodServer server = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)cm, (int)port, (HotRodServerConfigurationBuilder)new HotRodServerConfigurationBuilder());
        InetSocketAddress addr = new InetSocketAddress(server.getHost(), (int)server.getPort());
        this.addr2hrServer.put(addr, server);
        return server;
    }

    protected void killServer() {
        Iterator<HotRodServer> it = this.addr2hrServer.values().iterator();
        HotRodServer server = it.next();
        EmbeddedCacheManager cm = server.getCacheManager();
        it.remove();
        HotRodClientTestingUtil.killServers(server);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm});
        this.cacheManagers.remove(cm);
    }

    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() throws Throwable {
        if (this.cleanupAfterMethod()) {
            this.addr2hrServer.clear();
        }
        super.createBeforeMethod();
    }

    protected HitCountInterceptor getHitCountInterceptor(Cache<?, ?> cache) {
        return (HitCountInterceptor)TestingUtil.extractInterceptorChain(cache).findInterceptorWithClass(HitCountInterceptor.class);
    }

    protected void assertOnlyServerHit(SocketAddress serverAddress) {
        this.assertServerHit(serverAddress, null, 1);
    }

    protected void assertServerHit(SocketAddress serverAddress, String cacheName, int expectedHits) {
        EmbeddedCacheManager cacheContainer = this.addr2hrServer.get(serverAddress).getCacheManager();
        HitCountInterceptor interceptor = this.getHitCountInterceptor(this.namedCache(cacheName, (CacheContainer)cacheContainer));
        assert (interceptor.getHits() == expectedHits) : "Expected " + expectedHits + " hit(s) for " + String.valueOf(serverAddress) + " but received " + interceptor.getHits();
        for (HotRodServer server : this.addr2hrServer.values()) {
            if (server.getCacheManager() == cacheContainer) continue;
            interceptor = this.getHitCountInterceptor(this.namedCache(cacheName, (CacheContainer)server.getCacheManager()));
            assert (interceptor.getHits() == 0) : "Expected 0 hits in " + String.valueOf(serverAddress) + " but got " + interceptor.getHits();
        }
    }

    private Cache<?, ?> namedCache(String cacheName, CacheContainer cacheContainer) {
        return cacheName == null ? cacheContainer.getCache() : cacheContainer.getCache(cacheName);
    }

    protected void assertNoHits() {
        for (HotRodServer server : this.addr2hrServer.values()) {
            HitCountInterceptor interceptor = this.getHitCountInterceptor(server.getCacheManager().getCache());
            assert (interceptor.getHits() == 0) : "Expected 0 hits but got " + interceptor.getHits();
        }
    }

    protected InetSocketAddress getAddress(HotRodServer hotRodServer) {
        InetSocketAddress socketAddress = InetSocketAddress.createUnresolved(hotRodServer.getHost(), hotRodServer.getPort());
        this.addr2hrServer.put(socketAddress, hotRodServer);
        return socketAddress;
    }

    protected void resetStats() {
        for (EmbeddedCacheManager manager : this.cacheManagers) {
            HitCountInterceptor cmi = this.getHitCountInterceptor(manager.getCache());
            cmi.reset();
        }
    }

    protected void addInterceptors() {
        this.addInterceptors((String)null);
    }

    protected void addInterceptors(String cacheName) {
        for (EmbeddedCacheManager manager : this.cacheManagers) {
            Cache<?, ?> cache = this.namedCache(cacheName, (CacheContainer)manager);
            this.addInterceptors(cache);
        }
    }

    protected void addInterceptors(Cache<?, ?> cache) {
        this.addHitCountInterceptor(cache);
    }

    private void addHitCountInterceptor(Cache<?, ?> cache) {
        HitCountInterceptor interceptor = new HitCountInterceptor();
        TestingUtil.extractInterceptorChain(cache).addInterceptor((AsyncInterceptor)interceptor, 1);
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        this.clients.forEach(HotRodClientTestingUtil::killRemoteCacheManager);
        this.addr2hrServer.values().forEach(xva$0 -> HotRodClientTestingUtil.killServers(xva$0));
        this.addr2hrServer.clear();
        super.destroy();
    }

    public static class HitCountInterceptor
    extends BaseAsyncInterceptor {
        private static final Log log = LogFactory.getLog(HitCountInterceptor.class);
        private final AtomicInteger localSiteInvocationCount = new AtomicInteger(0);
        private final AtomicInteger backupSiteInvocationCount = new AtomicInteger(0);

        public Object visitCommand(InvocationContext ctx, VisitableCommand command) {
            if (command instanceof EntrySetCommand) {
                return this.invokeNext(ctx, command);
            }
            if (ctx.isOriginLocal()) {
                if (command instanceof AbstractDataCommand && ((AbstractDataCommand)command).hasAnyFlag(FlagBitSets.SKIP_XSITE_BACKUP)) {
                    int count = this.backupSiteInvocationCount.incrementAndGet();
                    log.debugf("Backup Hit %d for %s", count, (Object)command);
                } else {
                    int count = this.localSiteInvocationCount.incrementAndGet();
                    log.debugf("Local Hit %d for %s", count, (Object)command);
                }
            }
            return this.invokeNext(ctx, command);
        }

        public int getHits() {
            return this.localSiteInvocationCount.get();
        }

        public void reset() {
            this.localSiteInvocationCount.set(0);
            this.backupSiteInvocationCount.set(0);
        }
    }
}

