/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.RemoteCacheManagerTest", groups={"functional"})
public class RemoteCacheManagerTest
extends SingleCacheManagerTest {
    HotRodServer hotrodServer;
    int port;
    RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        this.port = this.hotrodServer.getPort();
        this.remoteCacheManager = null;
    }

    protected void teardown() {
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        this.hotrodServer = null;
        super.teardown();
    }

    @AfterMethod(alwaysRun=true)
    protected void stopClient() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)this.remoteCacheManager);
    }

    public void testStartStopAsync() throws Exception {
        this.remoteCacheManager = new RemoteCacheManager(false);
        this.remoteCacheManager.startAsync().get();
        AssertJUnit.assertTrue((boolean)this.remoteCacheManager.isStarted());
        this.remoteCacheManager.stopAsync().get();
        AssertJUnit.assertFalse((boolean)this.remoteCacheManager.isStarted());
    }

    public void testNoArgConstructor() {
        this.remoteCacheManager = new RemoteCacheManager();
        AssertJUnit.assertTrue((boolean)this.remoteCacheManager.isStarted());
    }

    public void testBooleanConstructor() {
        this.remoteCacheManager = new RemoteCacheManager(false);
        AssertJUnit.assertFalse((boolean)this.remoteCacheManager.isStarted());
        this.remoteCacheManager.start();
    }

    public void testConfigurationConstructor() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.port);
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
        AssertJUnit.assertTrue((boolean)this.remoteCacheManager.isStarted());
    }
}

