/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Collections;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.AbstractAuthenticationTest;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.server.core.security.simple.SimpleSaslAuthenticator;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.TestCallbackHandler;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.SecureListenerTest", groups={"functional"})
public class SecureListenerTest
extends AbstractAuthenticationTest {
    static final Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin"});
    static final String CACHE_NAME = "secured-listen";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper()).groupOnlyMapping(false);
        globalRoles.role("admin").permission(AuthorizationPermission.ALL).role("RWLuser").permission(new AuthorizationPermission[]{AuthorizationPermission.READ, AuthorizationPermission.WRITE, AuthorizationPermission.LISTEN}).role("RWUser").permission(new AuthorizationPermission[]{AuthorizationPermission.READ, AuthorizationPermission.WRITE});
        org.infinispan.configuration.cache.ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        config.security().authorization().enable().role("admin").role("RWLuser").role("RWUser");
        config.encoding().key().mediaType("application/x-protostream");
        config.encoding().value().mediaType("application/x-protostream");
        this.cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (org.infinispan.configuration.cache.ConfigurationBuilder)config);
        this.cacheManager.defineConfiguration(CACHE_NAME, config.build());
        this.cacheManager.getCache();
        this.hotrodServer = this.initServer(Collections.emptyMap(), 0);
        return this.cacheManager;
    }

    @Override
    protected SimpleSaslAuthenticator createAuthenticationProvider() {
        SimpleSaslAuthenticator sap = new SimpleSaslAuthenticator();
        sap.addUser("RWLuser", "realm", "password".toCharArray(), null);
        sap.addUser("RWuser", "realm", "password".toCharArray(), null);
        return sap;
    }

    protected void setup() throws Exception {
        Security.doAs((Subject)ADMIN, () -> {
            try {
                SecureListenerTest.super.setup();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    protected void teardown() {
        Security.doAs((Subject)ADMIN, () -> SecureListenerTest.super.teardown());
    }

    protected void clearCacheManager() {
        Security.doAs((Subject)ADMIN, () -> this.cacheManager.getCache().clear());
        if (this.remoteCacheManager != null) {
            HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)this.remoteCacheManager);
            this.remoteCacheManager = null;
        }
    }

    @Override
    protected HotRodServer initServer(Map<String, String> mechProperties, int index) {
        return (HotRodServer)Security.doAs((Subject)ADMIN, () -> SecureListenerTest.super.initServer(mechProperties, index));
    }

    public void testImplicitRemoveOnClose() {
        ConfigurationBuilder clientBuilder = this.newClientBuilder();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("RWLuser", null, "password"));
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        RemoteCache clientCache = this.remoteCacheManager.getCache(CACHE_NAME);
        EventLogListener<String> listener = new EventLogListener<String>(clientCache);
        clientCache.addClientListener(listener);
        Cache serverCache = this.cacheManager.getCache(CACHE_NAME);
        AssertJUnit.assertEquals((int)1, (int)TestingUtil.getListeners((Cache)serverCache).size());
        clientCache.put((Object)"key", (Object)"value");
        listener.expectSingleEvent("key", ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.remoteCacheManager.close();
        this.eventuallyEquals(0, () -> TestingUtil.getListeners((Cache)serverCache).size());
    }

    public void testAddListenerWithoutPermission() {
        ConfigurationBuilder clientBuilder = this.newClientBuilder();
        clientBuilder.security().authentication().saslMechanism("CRAM-MD5").username("RWuser").password("password");
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        RemoteCache clientCache = this.remoteCacheManager.getCache(CACHE_NAME);
        EventLogListener listener = new EventLogListener(clientCache);
        Exceptions.expectException(HotRodClientException.class, () -> clientCache.addClientListener((Object)listener));
        Cache serverCache = this.cacheManager.getCache(CACHE_NAME);
        AssertJUnit.assertEquals((int)0, (int)TestingUtil.getListeners((Cache)serverCache).size());
        this.remoteCacheManager.close();
        AssertJUnit.assertEquals((int)0, (int)TestingUtil.getListeners((Cache)serverCache).size());
    }
}

