/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.admin;

import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.annotation.model.Image;
import org.infinispan.client.hotrod.annotation.model.ModelA;
import org.infinispan.client.hotrod.annotation.model.ModelB;
import org.infinispan.client.hotrod.annotation.model.ModelC;
import org.infinispan.client.hotrod.annotation.model.SchemaA;
import org.infinispan.client.hotrod.annotation.model.SchemaB;
import org.infinispan.client.hotrod.annotation.model.SchemaC;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.admin.SchemaIndexUpdateTest")
public class SchemaIndexUpdateTest
extends SingleHotRodServerTest {
    private static final String CACHE_NAME = "models";
    private final ProtoStreamMarshaller schemaEvolutionClientMarshaller = new ProtoStreamMarshaller();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.encoding().mediaType("application/x-protostream").indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("model.Model");
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createServerModeCacheManager();
        cacheManager.defineConfiguration(CACHE_NAME, builder.build());
        return cacheManager;
    }

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        return HotRodClientTestingUtil.startHotRodServer(this.cacheManager, serverBuilder);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host(host).port(serverPort).addContextInitializer((SerializationContextInitializer)SchemaA.INSTANCE).marshaller((Marshaller)this.schemaEvolutionClientMarshaller);
        return builder;
    }

    @Test
    public void updateWithoutAndWithOtherEntities() {
        RemoteCache cache = this.remoteCacheManager.getCache(CACHE_NAME);
        cache.put((Object)1, (Object)new ModelA("Fabio"));
        Query query = cache.query("from model.Model where original is not null");
        List models = query.execute().list();
        Assertions.assertThat((List)models).extracting("original").containsExactly(new Object[]{"Fabio"});
        Assertions.assertThat((List)models).hasOnlyElementsOfType(ModelA.class);
        this.updateSchemaIndex(SchemaB.INSTANCE, null);
        cache.put((Object)2, (Object)new ModelB("Silvia", "Silvia"));
        query = cache.query("from model.Model where original is not null");
        models = query.execute().list();
        Assertions.assertThat((List)models).extracting("original").containsExactly(new Object[]{"Fabio", "Silvia"});
        Assertions.assertThat((List)models).hasOnlyElementsOfType(ModelB.class);
        query = cache.query("from model.Model where different is not null");
        models = query.execute().list();
        Assertions.assertThat((List)models).extracting("different").containsExactly(new Object[]{"Silvia"});
        Assertions.assertThat((List)models).hasOnlyElementsOfType(ModelB.class);
        Query imageQuery = cache.query("from model.Image where name is not null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> imageQuery.execute().list()).isInstanceOf(HotRodClientException.class)).hasMessageContaining("Unknown type name : model.Image");
        this.updateSchemaIndex(SchemaC.INSTANCE, "model.Model model.Image");
        cache.put((Object)3, (Object)new ModelC("Elena", "Elena", "Elena"));
        query = cache.query("from model.Model where original is not null");
        models = query.execute().list();
        Assertions.assertThat((List)models).extracting("original").containsExactly(new Object[]{"Fabio", "Silvia", "Elena"});
        Assertions.assertThat((List)models).hasOnlyElementsOfType(ModelC.class);
        query = cache.query("from model.Model where different is not null");
        models = query.execute().list();
        Assertions.assertThat((List)models).extracting("different").containsExactly(new Object[]{"Silvia", "Elena"});
        Assertions.assertThat((List)models).hasOnlyElementsOfType(ModelC.class);
        query = cache.query("from model.Model where divergent is not null");
        models = query.execute().list();
        Assertions.assertThat((List)models).extracting("divergent").containsExactly(new Object[]{"Elena"});
        Assertions.assertThat((List)models).hasOnlyElementsOfType(ModelC.class);
        List images = imageQuery.execute().list();
        Assertions.assertThat((List)images).isEmpty();
        cache.put((Object)4, (Object)new Image("name"));
        images = imageQuery.execute().list();
        Assertions.assertThat((List)images).extracting("name").containsExactly(new Object[]{"name"});
        Assertions.assertThat((List)images).hasOnlyElementsOfType(Image.class);
    }

    private void updateSchemaIndex(GeneratedSchema schema, String newIndexedEntities) {
        schema.registerSchema(this.schemaEvolutionClientMarshaller.getSerializationContext());
        schema.registerMarshallers(this.schemaEvolutionClientMarshaller.getSerializationContext());
        RemoteCache metadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)schema.getProtoFileName(), (Object)schema.getProtoFile());
        if (newIndexedEntities != null) {
            ((RemoteCacheManagerAdmin)this.remoteCacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).updateConfigurationAttribute(CACHE_NAME, "indexing.indexed-entities", newIndexedEntities);
        }
        this.remoteCacheManager.administration().updateIndexSchema(CACHE_NAME);
    }
}

