/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.admin;

import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.admin.RemoteCacheAdminTest;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.core.security.sasl.SaslAuthenticator;
import org.infinispan.server.core.security.simple.SimpleSaslAuthenticator;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.admin.SecureRemoteCacheAdminTest")
public class SecureRemoteCacheAdminTest
extends RemoteCacheAdminTest {
    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder builder = super.createHotRodClientConfigurationBuilder(host, serverPort);
        builder.security().authentication().enable().saslMechanism("CRAM-MD5").username("admin").password("password");
        return builder;
    }

    @Override
    protected HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.defaultCacheName("default");
        ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        gcb.security().authorization().enable().groupOnlyMapping(false).principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper()).role("admin").permission(AuthorizationPermission.ALL);
        gcb.serialization().addContextInitializer(this.contextInitializer());
        org.infinispan.configuration.cache.ConfigurationBuilder template = new org.infinispan.configuration.cache.ConfigurationBuilder();
        template.read(builder.build());
        template.security().authorization().role("admin");
        EmbeddedCacheManager cm = (EmbeddedCacheManager)Security.doPrivileged(() -> {
            EmbeddedCacheManager cacheManager = this.addClusterEnabledCacheManager(gcb, builder);
            cacheManager.defineConfiguration("template", builder.build());
            cacheManager.defineConfiguration(DefaultTemplate.DIST_ASYNC.getTemplateName(), builder.build());
            return cacheManager;
        });
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        SimpleSaslAuthenticator ssa = new SimpleSaslAuthenticator();
        ssa.addUser("admin", "realm", "password".toCharArray(), new String[]{"admin"});
        serverBuilder.authentication().enable().sasl().authenticator((SaslAuthenticator)ssa).serverName("localhost").addAllowedMech("CRAM-MD5");
        HotRodServer server = (HotRodServer)Security.doPrivileged(() -> HotRodClientTestingUtil.startHotRodServer(cm, serverBuilder));
        this.servers.add(server);
        return server;
    }
}

