/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientListenerRemoveOnStopTest")
public class ClientListenerRemoveOnStopTest
extends SingleHotRodServerTest {
    public void testAllListenersRemovedOnStop() {
        RemoteCache rcache = this.remoteCacheManager.getCache();
        EventLogListener eventListener1 = new EventLogListener(rcache);
        rcache.addClientListener(eventListener1);
        Set<Object> listeners = HotRodClientTestingUtil.getListeners(rcache);
        AssertJUnit.assertEquals((int)1, (int)listeners.size());
        AssertJUnit.assertEquals(eventListener1, (Object)listeners.iterator().next());
        EventLogListener eventListener2 = new EventLogListener(rcache);
        rcache.addClientListener(eventListener2);
        listeners = HotRodClientTestingUtil.getListeners(rcache);
        AssertJUnit.assertEquals((int)2, (int)listeners.size());
        AssertJUnit.assertTrue((boolean)listeners.contains(eventListener1));
        AssertJUnit.assertTrue((boolean)listeners.contains(eventListener2));
        this.remoteCacheManager.stop();
        listeners = HotRodClientTestingUtil.getListeners(rcache);
        AssertJUnit.assertEquals((int)0, (int)listeners.size());
    }

    public void testRemoveListenerAfterStopAndRestart() throws Exception {
        this.remoteCacheManager.start();
        RemoteCache rcache = this.remoteCacheManager.getCache();
        EventLogListener eventListener1 = new EventLogListener(rcache);
        rcache.addClientListener(eventListener1);
        Set<Object> listeners = HotRodClientTestingUtil.getListeners(rcache);
        AssertJUnit.assertEquals((int)1, (int)listeners.size());
        AssertJUnit.assertTrue((boolean)listeners.contains(eventListener1));
        int port = this.hotrodServer.getPort();
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
        this.eventuallyEquals(0, () -> HotRodClientTestingUtil.getListeners(rcache).size());
        this.cacheManager = this.createCacheManager();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager, port, new HotRodServerConfigurationBuilder());
        rcache.removeClientListener(eventListener1);
        listeners = HotRodClientTestingUtil.getListeners(rcache);
        AssertJUnit.assertEquals((int)0, (int)listeners.size());
    }
}

