/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientEventSCI;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.filter.NamedFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientListenerWithFilterAndProtobufTest")
public class ClientListenerWithFilterAndProtobufTest
extends MultiHotRodServersTest {
    private final int NUM_NODES = 2;
    private RemoteCache<Object, Object> remoteCache;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder defaultClusteredCacheConfig = ClientListenerWithFilterAndProtobufTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        defaultClusteredCacheConfig.encoding().key().mediaType("application/x-protostream");
        defaultClusteredCacheConfig.encoding().value().mediaType("application/x-protostream");
        ConfigurationBuilder cfgBuilder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)defaultClusteredCacheConfig);
        this.createHotRodServers(2, cfgBuilder);
        this.waitForClusterToForm();
        for (int i = 0; i < 2; ++i) {
            this.server(i).addCacheEventFilterFactory("custom-filter-factory", (CacheEventFilterFactory)new CustomCacheEventFilterFactory());
        }
        this.remoteCache = this.client(0).getCache();
    }

    @Override
    protected List<SerializationContextInitializer> contextInitializers() {
        return Arrays.asList(TestDomainSCI.INSTANCE, ClientEventSCI.INSTANCE);
    }

    public void testEventFilter() throws Exception {
        Object[] filterFactoryParams = new Object[]{"string_key_1", "user_1"};
        ClientEntryListener listener = new ClientEntryListener();
        this.remoteCache.addClientListener((Object)listener, filterFactoryParams, null);
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(22);
        this.remoteCache.put((Object)"string_key_1", (Object)"string value 1");
        this.remoteCache.put((Object)"string_key_2", (Object)"string value 2");
        this.remoteCache.put((Object)"user_1", (Object)user1);
        AssertJUnit.assertEquals((int)3, (int)this.remoteCache.keySet().size());
        ClientCacheEntryCreatedEvent e = listener.createEvents.poll(5L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)"string_key_1", (Object)e.getKey());
        e = listener.createEvents.poll(5L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)"user_1", (Object)e.getKey());
        e = listener.createEvents.poll(5L, TimeUnit.SECONDS);
        AssertJUnit.assertNull((String)"No more elements expected in queue!", (Object)e);
    }

    @NamedFactory(name="custom-filter-factory")
    public static class CustomCacheEventFilterFactory
    implements CacheEventFilterFactory {
        public CacheEventFilter<String, Object> getFilter(Object[] params) {
            String firstParam = (String)params[0];
            String secondParam = (String)params[1];
            return new CustomEventFilter(firstParam, secondParam);
        }
    }

    @ClientListener(filterFactoryName="custom-filter-factory")
    public static class ClientEntryListener {
        public final BlockingQueue<ClientCacheEntryCreatedEvent> createEvents = new LinkedBlockingQueue<ClientCacheEntryCreatedEvent>();

        @ClientCacheEntryCreated
        public void handleClientCacheEntryCreatedEvent(ClientCacheEntryCreatedEvent event) {
            this.createEvents.add(event);
        }
    }

    public static class CustomEventFilter
    implements CacheEventFilter<String, Object> {
        @ProtoField(value=1)
        final String firstParam;
        @ProtoField(value=2)
        final String secondParam;

        @ProtoFactory
        CustomEventFilter(String firstParam, String secondParam) {
            this.firstParam = firstParam;
            this.secondParam = secondParam;
        }

        public boolean accept(String key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
            return this.firstParam.equals(key) || this.secondParam.equals(key);
        }
    }
}

