/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.evolution;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.model.Model;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.evolution.model.BaseEntityWithNonAnalyzedNameFieldEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNameFieldAnalyzedEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNameFieldIndexedEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNameIndexedAndNameFieldEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNameIndexedFieldEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNewIndexedFieldEntity;
import org.infinispan.client.hotrod.evolution.model.ModelUtils;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.evolution.IndexSchemaNoDowntimeUpgradeTest")
public class IndexSchemaNoDowntimeUpgradeTest
extends SingleHotRodServerTest {
    private static final String CACHE_NAME = "models";
    private final ProtoStreamMarshaller schemaEvolutionClientMarshaller = new ProtoStreamMarshaller();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.encoding().mediaType("application/x-protostream").indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("evolution.Model");
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createServerModeCacheManager();
        cacheManager.defineConfiguration(CACHE_NAME, builder.build());
        return cacheManager;
    }

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        return HotRodClientTestingUtil.startHotRodServer(this.cacheManager, serverBuilder);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host(host).port(serverPort).marshaller((Marshaller)this.schemaEvolutionClientMarshaller);
        return builder;
    }

    private void updateSchemaIndex(GeneratedSchema schema) {
        schema.registerSchema(this.schemaEvolutionClientMarshaller.getSerializationContext());
        schema.registerMarshallers(this.schemaEvolutionClientMarshaller.getSerializationContext());
        RemoteCache metadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)schema.getProtoFileName(), (Object)schema.getProtoFile());
        this.remoteCacheManager.administration().updateIndexSchema(CACHE_NAME);
    }

    @AfterMethod
    void clean() {
        this.remoteCacheManager.getCache(CACHE_NAME).clear();
    }

    @Test
    void testAddNewFieldWithIndex() {
        this.updateSchemaIndex(BaseModelEntity.BaseModelEntitySchema.INSTANCE);
        RemoteCache cache = this.remoteCacheManager.getCache(CACHE_NAME);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelEntity(1));
        this.doQuery("FROM evolution.Model WHERE name LIKE '%3%'", cache, 1);
        this.updateSchemaIndex(BaseModelWithNewIndexedFieldEntity.BaseModelWithNewIndexedFieldEntitySchema.INSTANCE);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelWithNewIndexedFieldEntity(2));
        Assertions.assertThat((int)cache.size()).isEqualTo(10);
        this.doQuery("FROM evolution.Model WHERE newField LIKE '%3%'", cache, 1);
        this.doQuery("FROM evolution.Model WHERE newField LIKE 'Cool%fiEld%3%' ORDER BY newField", cache, 1);
    }

    @Test
    void testAddAIndexOnExistingFieldThatWasNotUsedInAnyQueryBefore() {
        this.updateSchemaIndex(BaseModelEntity.BaseModelEntitySchema.INSTANCE);
        RemoteCache cache = this.remoteCacheManager.getCache(CACHE_NAME);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelEntity(1));
        this.doQuery("FROM evolution.Model WHERE name LIKE '%3%'", cache, 1);
        this.updateSchemaIndex(BaseModelWithNameIndexedAndNameFieldEntity.BaseModelWithNameIndexedAndNameFieldEntitySchema.INSTANCE);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelWithNameIndexedAndNameFieldEntity(2));
        this.doQuery("FROM evolution.Model WHERE name LIKE '%3%'", cache, 2);
        this.doQuery("FROM evolution.Model WHERE nameAnalyzed : '*3*'", cache, 1);
        this.migrateBaseModelEntityToBaseModelWithNameIndexedAndNameFieldEntity((RemoteCache<String, BaseModelWithNameIndexedAndNameFieldEntity>)this.remoteCacheManager.getCache(CACHE_NAME));
        this.updateSchemaIndex(BaseModelWithNameIndexedFieldEntity.BaseModelWithNameIndexedFieldEntitySchema.INSTANCE);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelWithNameIndexedFieldEntity(3));
        BaseModelWithNameIndexedAndNameFieldEntity.BaseModelWithNameIndexedAndNameFieldEntitySchema.INSTANCE.registerSchema(this.schemaEvolutionClientMarshaller.getSerializationContext());
        BaseModelWithNameIndexedAndNameFieldEntity.BaseModelWithNameIndexedAndNameFieldEntitySchema.INSTANCE.registerMarshallers(this.schemaEvolutionClientMarshaller.getSerializationContext());
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, i -> ModelUtils.createBaseModelWithNameIndexedAndNameFieldEntity(2).apply(i + 10));
        RemoteCache cacheV2Typed = this.remoteCacheManager.getCache(CACHE_NAME);
        BaseModelWithNameIndexedAndNameFieldEntity BaseModelWithNameIndexedAndNameFieldEntity2 = (BaseModelWithNameIndexedAndNameFieldEntity)cacheV2Typed.get((Object)"300013");
        Assertions.assertThat((String)BaseModelWithNameIndexedAndNameFieldEntity2.name).isEqualTo("modelD # 13");
        this.doQuery("FROM evolution.Model WHERE nameAnalyzed : '*3*'", cache, 4);
    }

    @Test
    void testRemoveIndexWhenNoLongerUsedInQueryInNewerVersion() {
        this.updateSchemaIndex(BaseModelWithNameFieldIndexedEntity.BaseModelWithNameFieldIndexedEntitySchema.INSTANCE);
        RemoteCache cache = this.remoteCacheManager.getCache(CACHE_NAME);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelWithNameFieldIndexedEntity(1));
        this.doQuery("FROM evolution.Model WHERE name LIKE '%3%'", cache, 1);
        this.updateSchemaIndex(BaseModelEntity.BaseModelEntitySchema.INSTANCE);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelEntity(2));
        this.doQuery("FROM evolution.Model WHERE entityVersion >= 1", cache, 10);
    }

    @Test
    void testMigrateAnalyzedFieldToNonAnalyzed() {
        this.updateSchemaIndex(BaseModelWithNameFieldAnalyzedEntity.BaseModelWithNameFieldAnalyzedEntitySchema.INSTANCE);
        RemoteCache cache = this.remoteCacheManager.getCache(CACHE_NAME);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelWithNameFieldAnalyzedEntity(1));
        this.doQuery("FROM evolution.Model WHERE nameAnalyzed : '*3*'", cache, 1);
        this.updateSchemaIndex(BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity.BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntitySchema.INSTANCE);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity(2));
        this.doQuery("FROM evolution.Model WHERE (entityVersion < 2 AND nameAnalyzed : '*3*') OR (entityVersion >= 2 AND nameNonAnalyzed LIKE '%3%')", cache, 2);
        this.migrateBaseModelWithNameFieldAnalyzedEntitySchemaToBaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity((RemoteCache<String, BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity>)this.remoteCacheManager.getCache(CACHE_NAME));
        this.doQuery("FROM evolution.Model WHERE nameNonAnalyzed LIKE '%3%'", cache, 2);
        this.updateSchemaIndex(BaseEntityWithNonAnalyzedNameFieldEntity.BaseEntityWithNonAnalyzedNameFieldEntitySchema.INSTANCE);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseEntityWithNonAnalyzedNameFieldEntity(3));
        this.doQuery("FROM evolution.Model WHERE nameNonAnalyzed LIKE '%3%'", cache, 3);
    }

    @Test
    void testMigrateNonAnalyzedFieldToAnalyzed() {
        this.updateSchemaIndex(BaseModelWithNameFieldIndexedEntity.BaseModelWithNameFieldIndexedEntitySchema.INSTANCE);
        RemoteCache cache = this.remoteCacheManager.getCache(CACHE_NAME);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelWithNameFieldIndexedEntity(1));
        this.doQuery("FROM evolution.Model WHERE name LIKE '%3%'", cache, 1);
        this.updateSchemaIndex(BaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntity.BaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntitySchema.INSTANCE);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntity(2));
        this.doQuery("FROM evolution.Model WHERE (entityVersion < 2 AND name LIKE '%3%') OR (entityVersion >= 2 AND nameAnalyzed : '*3*')", cache, 2);
        this.migrateBaseModelWithNameFieldIndexedEntityToBaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntity((RemoteCache<String, BaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntity>)this.remoteCacheManager.getCache(CACHE_NAME));
        this.doQuery("FROM evolution.Model WHERE nameAnalyzed : '*3*'", cache, 2);
        this.updateSchemaIndex(BaseModelWithNameIndexedFieldEntity.BaseModelWithNameIndexedFieldEntitySchema.INSTANCE);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelWithNameIndexedFieldEntity(3));
        this.doQuery("FROM evolution.Model WHERE nameAnalyzed : '*3*'", cache, 3);
    }

    @Test
    void testAddNonAnalyzedIndexOnExistingField() {
        this.updateSchemaIndex(BaseModelEntity.BaseModelEntitySchema.INSTANCE);
        RemoteCache cache = this.remoteCacheManager.getCache(CACHE_NAME);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelEntity(1));
        this.doQuery("FROM evolution.Model WHERE name LIKE '%3%'", cache, 1);
        this.updateSchemaIndex(BaseModelWithNameFieldIndexedEntity.BaseModelWithNameFieldIndexedEntitySchema.INSTANCE);
        ModelUtils.createModelEntities((RemoteCache<String, Model>)cache, 5, ModelUtils.createBaseModelWithNameFieldIndexedEntity(2));
        this.doQuery("FROM evolution.Model WHERE name LIKE '%3%'", cache, 2);
    }

    private <T> void doQuery(String query, RemoteCache<String, T> messageCache, int expectedResults) {
        Query infinispanObjectEntities = messageCache.query(query);
        List result = StreamSupport.stream(infinispanObjectEntities.spliterator(), false).collect(Collectors.toList());
        Assertions.assertThat(result).hasSize(expectedResults);
    }

    private Stream doQuery(String query, RemoteCache<String, Model> messageCache) {
        Query infinispanObjectEntities = messageCache.query(query);
        return StreamSupport.stream(infinispanObjectEntities.spliterator(), false);
    }

    private void migrateBaseModelEntityToBaseModelWithNameIndexedAndNameFieldEntity(RemoteCache<String, BaseModelWithNameIndexedAndNameFieldEntity> cache) {
        new HashSet(cache.keySet()).forEach(e -> {
            BaseModelWithNameIndexedAndNameFieldEntity BaseModelWithNameIndexedAndNameFieldEntity2 = (BaseModelWithNameIndexedAndNameFieldEntity)cache.get(e);
            if (BaseModelWithNameIndexedAndNameFieldEntity2.entityVersion == 1) {
                BaseModelWithNameIndexedAndNameFieldEntity2.nameAnalyzed = BaseModelWithNameIndexedAndNameFieldEntity2.name;
                BaseModelWithNameIndexedAndNameFieldEntity2.name = null;
                BaseModelWithNameIndexedAndNameFieldEntity2.entityVersion = 2;
                cache.put((Object)BaseModelWithNameIndexedAndNameFieldEntity2.id, (Object)BaseModelWithNameIndexedAndNameFieldEntity2);
            }
        });
    }

    private void migrateBaseModelWithNameFieldAnalyzedEntitySchemaToBaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity(RemoteCache<String, BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity> cache) {
        new HashSet(cache.keySet()).forEach(e -> {
            BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity2 = (BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity)cache.get(e);
            if (BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity2.entityVersion == 1) {
                BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity2.nameNonAnalyzed = BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity2.nameAnalyzed;
                BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity2.nameAnalyzed = null;
                BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity2.entityVersion = 2;
                cache.put((Object)BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity2.id, (Object)BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity2);
            }
        });
    }

    private void migrateBaseModelWithNameFieldIndexedEntityToBaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntity(RemoteCache<String, BaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntity> cache) {
        new HashSet(cache.keySet()).forEach(e -> {
            BaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntity ModelG = (BaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntity)cache.get(e);
            if (ModelG.entityVersion == 1) {
                ModelG.nameAnalyzed = ModelG.name;
                ModelG.name = null;
                ModelG.entityVersion = 2;
                cache.put((Object)ModelG.id, (Object)ModelG);
            }
        });
    }
}

