/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.evolution.model;

import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.model.Model;
import org.infinispan.client.hotrod.evolution.model.BaseEntityWithNonAnalyzedNameFieldEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelIndexAttributesChangedEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelIndexAttributesEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNameFieldAnalyzedEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNameFieldIndexedEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNameIndexedAndNameFieldEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNameIndexedFieldEntity;
import org.infinispan.client.hotrod.evolution.model.BaseModelWithNewIndexedFieldEntity;

public class ModelUtils {
    private static final int ID_VERSION_OFFSET = 100000;

    public static Function<Integer, Model> createBaseModelEntity(int version) {
        return i -> {
            BaseModelEntity m = new BaseModelEntity();
            m.entityVersion = version;
            m.id = String.valueOf(i);
            m.name = "modelA # " + i;
            return m;
        };
    }

    public static Function<Integer, Model> createBaseModelWithNameFieldIndexedEntity(int version) {
        return i -> {
            BaseModelWithNameFieldIndexedEntity m = new BaseModelWithNameFieldIndexedEntity();
            m.entityVersion = version;
            m.id = String.valueOf(100000 + i);
            m.name = "modelB # " + i;
            return m;
        };
    }

    public static Function<Integer, Model> createBaseModelWithNameFieldAnalyzedEntity(int version) {
        return i -> {
            BaseModelWithNameFieldAnalyzedEntity m = new BaseModelWithNameFieldAnalyzedEntity();
            m.entityVersion = version;
            m.id = String.valueOf(200000 + i);
            m.nameAnalyzed = "modelC # " + i;
            return m;
        };
    }

    public static Function<Integer, Model> createBaseModelWithNameIndexedAndNameFieldEntity(int version) {
        return i -> {
            BaseModelWithNameIndexedAndNameFieldEntity m = new BaseModelWithNameIndexedAndNameFieldEntity();
            m.entityVersion = version;
            m.id = String.valueOf(300000 + i);
            m.name = "modelD # " + i;
            m.nameAnalyzed = "modelD # " + i;
            return m;
        };
    }

    public static Function<Integer, Model> createBaseModelWithNewIndexedFieldEntity(int version) {
        return i -> {
            BaseModelWithNewIndexedFieldEntity m = new BaseModelWithNewIndexedFieldEntity();
            m.entityVersion = version;
            m.id = String.valueOf(400000 + i);
            m.name = "modelE # " + i;
            m.newField = "cOoLNewField-" + i;
            return m;
        };
    }

    public static Function<Integer, Model> createBaseModelWithNameIndexedFieldEntity(int version) {
        return i -> {
            BaseModelWithNameIndexedFieldEntity m = new BaseModelWithNameIndexedFieldEntity();
            m.entityVersion = version;
            m.id = String.valueOf(500000 + i);
            m.nameAnalyzed = "modelF # " + i;
            return m;
        };
    }

    public static Function<Integer, Model> createBaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity(int version) {
        return i -> {
            BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity m = new BaseModelWithNameAnalyzedAndNameNonAnalyzedFieldEntity();
            m.entityVersion = version;
            m.id = String.valueOf(600000 + i);
            m.nameAnalyzed = "modelG # " + i;
            m.nameNonAnalyzed = m.nameAnalyzed;
            return m;
        };
    }

    public static Function<Integer, Model> createBaseEntityWithNonAnalyzedNameFieldEntity(int version) {
        return i -> {
            BaseEntityWithNonAnalyzedNameFieldEntity m = new BaseEntityWithNonAnalyzedNameFieldEntity();
            m.entityVersion = version;
            m.id = String.valueOf(700000 + i);
            m.nameNonAnalyzed = "modelH # " + i;
            return m;
        };
    }

    public static Function<Integer, Model> createBaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntity(int version) {
        return i -> {
            BaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntity m = new BaseModelWithNameFieldIndexedAndNameAnalyzedFieldEntity();
            m.entityVersion = version;
            m.id = String.valueOf(700000 + i);
            m.nameAnalyzed = "modelI # " + i;
            m.name = "modelI # " + i;
            return m;
        };
    }

    public static Function<Integer, Model> createBaseModelIndexAttributesEntity(int version) {
        return i -> {
            BaseModelIndexAttributesEntity m = new BaseModelIndexAttributesEntity();
            m.entityVersion = version;
            m.id = String.valueOf(800000 + i);
            m.number = i;
            m.name = "modelK # " + i;
            m.normalizedField = "modelK # lowercase NORMALIZED field " + i;
            m.analyzedField = "modelK # standard ANALYZED field " + i;
            return m;
        };
    }

    public static Function<Integer, Model> createBaseModelIndexAttributesChangedEntity(int version) {
        return i -> {
            BaseModelIndexAttributesChangedEntity m = new BaseModelIndexAttributesChangedEntity();
            m.entityVersion = version;
            m.id = String.valueOf(900000 + i);
            m.number = i;
            m.name = "modelL # " + i;
            m.normalizedField = "modelL # NORMALIZED field " + i;
            m.analyzedField = "modelL # keyword ANALYZED field " + i;
            return m;
        };
    }

    public static void createModelEntities(RemoteCache<String, Model> cache, int number, Function<Integer, Model> modelProducer) {
        for (int i = 0; i < number; ++i) {
            Model m = modelProducer.apply(i);
            cache.put((Object)m.getId(), (Object)m);
        }
    }
}

