/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.hash;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.protocol.CodecHolder;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.hash.ConsistentHashTest")
public class ConsistentHashTest
extends MultiHotRodServersTest {
    private static final int NUM_SERVERS = 3;
    private MediaType keyType = null;

    protected ConsistentHashTest withKeyType(MediaType keyType) {
        this.keyType = keyType;
        return this;
    }

    public void testKeysMapToCorrectSegment() {
        RemoteCacheManager rcm = (RemoteCacheManager)this.clients.get(0);
        rcm.start();
        HashMap requests = new HashMap();
        RemoteCache cache = rcm.getCache();
        for (int i = 0; i < 100; ++i) {
            Object keyValue = this.kv(i);
            ((ControlledChannelFactory)rcm.getChannelFactory()).useOnFetch((server, op) -> requests.put(keyValue, server));
            cache.put(keyValue, keyValue);
        }
        for (Map.Entry entry : requests.entrySet()) {
            int port = ((InetSocketAddress)entry.getValue()).getPort();
            HotRodServer server2 = this.findServer(port);
            Cache c = server2.getCacheManager().getCache();
            Object r = c.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).get(entry.getKey());
            Assertions.assertThat((Object)r).isEqualTo(entry.getKey());
        }
    }

    private Object kv(int i) {
        return String.valueOf(i);
    }

    private HotRodServer findServer(int port) {
        for (HotRodServer server : this.servers) {
            if (server.getAddress().getPort() != port) continue;
            return server;
        }
        throw new IllegalStateException("Server not found for port: " + port);
    }

    public Object[] factory() {
        return new Object[]{new ConsistentHashTest(), new ConsistentHashTest().withKeyType(MediaType.APPLICATION_PROTOSTREAM), new ConsistentHashTest().withKeyType(MediaType.APPLICATION_OBJECT), new ConsistentHashTest().withKeyType(MediaType.TEXT_PLAIN)};
    }

    protected String parameters() {
        return " -- key-type=" + String.valueOf(this.keyType);
    }

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(3, this.getCacheConfiguration());
    }

    private ConfigurationBuilder getCacheConfiguration() {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)ConsistentHashTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        if (this.keyType != null) {
            builder.encoding().key().mediaType(this.keyType);
        }
        builder.clustering().hash().numOwners(1);
        return builder;
    }

    @Override
    protected RemoteCacheManager createClient(int i) {
        Configuration cfg = this.createHotRodClientConfigurationBuilder(this.server(i)).build();
        return new InternalRemoteCacheManager(cfg, new ControlledChannelFactory(cfg));
    }

    private static class ControlledChannelFactory
    extends ChannelFactory {
        private BiConsumer<SocketAddress, ChannelOperation> onFetch;

        public ControlledChannelFactory(Configuration cfg) {
            super(new CodecHolder(cfg.version().getCodec()));
        }

        public void useOnFetch(BiConsumer<SocketAddress, ChannelOperation> onFetch) {
            this.onFetch = onFetch;
        }

        public <T extends ChannelOperation> T fetchChannelAndInvoke(SocketAddress server, T operation) {
            if (this.onFetch != null) {
                this.onFetch.accept(server, operation);
            }
            return (T)super.fetchChannelAndInvoke(server, operation);
        }
    }
}

