/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.iteration.SCIImpl;
import org.infinispan.client.hotrod.impl.iteration.Util;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.filter.ParamKeyValueFilterConverterFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.query.dsl.embedded.DslSCI;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseMultiServerRemoteIteratorTest
extends MultiHotRodServersTest {
    public static final int CACHE_SIZE = 20;

    @BeforeMethod
    public void clear() {
        this.clients.forEach(c -> c.getCache().clear());
    }

    @Override
    protected void modifyGlobalConfiguration(GlobalConfigurationBuilder builder) {
        builder.serialization().addContextInitializer((SerializationContextInitializer)SCI.INSTANCE);
    }

    @Override
    protected RemoteCacheManager createClient(int i) {
        Configuration cfg = this.createHotRodClientConfigurationBuilder(this.server(i)).addContextInitializer((SerializationContextInitializer)DslSCI.INSTANCE).build();
        return new InternalRemoteCacheManager(cfg);
    }

    protected <T> Map.Entry<Object, T> convertEntry(Map.Entry<Object, ?> entry) {
        return entry;
    }

    protected <T> T convertKey(Object key) {
        return (T)key;
    }

    @Test
    public void testBatchSizes() {
        int maximumBatchSize = 120;
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        Util.populateCache(20, Util::newAccount, cache);
        Set<Integer> expectedKeys = Util.rangeAsSet(0, 20);
        for (int batch = 1; batch < maximumBatchSize; batch += 10) {
            HashSet<Map.Entry<Object, Object>> results = new HashSet<Map.Entry<Object, Object>>(20);
            CloseableIterator iterator = cache.retrieveEntries(null, null, batch);
            iterator.forEachRemaining(r -> results.add(this.convertEntry((Map.Entry<Object, ?>)r)));
            iterator.close();
            AssertJUnit.assertEquals((int)20, (int)results.size());
            AssertJUnit.assertEquals(expectedKeys, Util.extractKeys(results));
        }
    }

    @Test
    public void testEmptyCache() {
        try (CloseableIterator iterator = this.client(0).getCache().retrieveEntries(null, null, 100);){
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testFilterBySegmentAndCustomFilter() {
        String toHexConverterName = "toHexConverter";
        this.servers.forEach(s -> s.addKeyValueFilterConverterFactory(toHexConverterName, (KeyValueFilterConverterFactory)new ToHexConverterFactory()));
        RemoteCache numbersCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        Util.populateCache(20, i -> i, numbersCache);
        Set<Integer> segments = Util.setOf(15, 20, 25);
        HashSet<Map.Entry<Object, Object>> entries = new HashSet<Map.Entry<Object, Object>>();
        try (CloseableIterator iterator = numbersCache.retrieveEntries(toHexConverterName, segments, 10);){
            while (iterator.hasNext()) {
                entries.add((Map.Entry)iterator.next());
            }
        }
        Set values = Util.extractValues(entries);
        this.getKeysFromSegments(segments).forEach(i -> Assert.assertTrue((boolean)values.contains(Integer.toHexString(i))));
    }

    @Test
    public void testFilterByCustomParamFilter() {
        String factoryName = "substringConverter";
        this.servers.forEach(s -> s.addKeyValueFilterConverterFactory(factoryName, (KeyValueFilterConverterFactory)new SubstringFilterFactory()));
        int filterParam = 12;
        RemoteCache stringCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        IntStream.rangeClosed(0, 19).forEach(idx -> stringCache.put((Object)String.valueOf(idx), (Object)org.infinispan.commons.util.Util.threadLocalRandomUUID().toString()));
        Set<Map.Entry<Object, Object>> entries = Util.extractEntries((CloseableIterator<Map.Entry<Object, Object>>)stringCache.retrieveEntries(factoryName, new Object[]{filterParam}, null, 10));
        Set values = Util.extractValues(entries);
        Util.assertForAll(values, s -> s.length() == filterParam);
        entries = Util.extractEntries((CloseableIterator<Map.Entry<Object, Object>>)stringCache.retrieveEntries(factoryName, 10));
        values = Util.extractValues(entries);
        Util.assertForAll(values, s -> s.length() == 20);
    }

    @Test
    public void testFilterBySegment() {
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        Util.populateCache(20, Util::newAccount, cache);
        CacheTopologyInfo cacheTopologyInfo = cache.getCacheTopologyInfo();
        Set filterBySegments = (Set)cacheTopologyInfo.getSegmentsPerServer().values().iterator().next();
        HashSet<Map.Entry<Object, Object>> entries = new HashSet<Map.Entry<Object, Object>>();
        try (CloseableIterator iterator = cache.retrieveEntries(null, filterBySegments, 10);){
            while (iterator.hasNext()) {
                entries.add((Map.Entry)iterator.next());
            }
        }
        Marshaller marshaller = ((RemoteCacheManager)this.clients.get(0)).getMarshaller();
        KeyPartitioner keyPartitioner = (KeyPartitioner)TestingUtil.extractComponent((Cache)this.cache(0), KeyPartitioner.class);
        DataFormat df = cache.getDataFormat();
        Util.assertKeysInSegment(entries, filterBySegments, marshaller, this.extractKeySegment(cache));
    }

    private Function<byte[], Integer> extractKeySegment(RemoteCache<?, ?> cache) {
        KeyPartitioner keyPartitioner = (KeyPartitioner)TestingUtil.extractComponent((Cache)this.cache(0), KeyPartitioner.class);
        DataFormat df = cache.getDataFormat();
        ClassAllowList cal = ((RemoteCacheManager)this.clients.get(0)).getConfiguration().getClassAllowList();
        return data -> {
            if (df != null) {
                if (df.isObjectStorage()) {
                    return keyPartitioner.getSegment(df.keyToObj(data, cal));
                }
                if (df.server() != null) {
                    data = df.server().keyToBytes(df.keyToObj(data, cal));
                }
            }
            return keyPartitioner.getSegment(data);
        };
    }

    @Test
    public void testRetrieveMetadata() {
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        cache.put((Object)1, (Object)Util.newAccount(1), 1L, TimeUnit.DAYS);
        cache.put((Object)2, (Object)Util.newAccount(2), 2L, TimeUnit.MINUTES, 30L, TimeUnit.SECONDS);
        cache.put((Object)3, (Object)Util.newAccount(3));
        try (CloseableIterator iterator = cache.retrieveEntriesWithMetadata(null, 10);){
            Map.Entry entry = this.convertEntry((Map.Entry)iterator.next());
            if ((Integer)entry.getKey() == 1) {
                AssertJUnit.assertEquals((int)86400, (int)((MetadataValue)entry.getValue()).getLifespan());
                AssertJUnit.assertEquals((int)-1, (int)((MetadataValue)entry.getValue()).getMaxIdle());
            }
            if ((Integer)entry.getKey() == 2) {
                AssertJUnit.assertEquals((int)120, (int)((MetadataValue)entry.getValue()).getLifespan());
                AssertJUnit.assertEquals((int)30, (int)((MetadataValue)entry.getValue()).getMaxIdle());
            }
            if ((Integer)entry.getKey() == 3) {
                AssertJUnit.assertEquals((int)-1, (int)((MetadataValue)entry.getValue()).getLifespan());
                AssertJUnit.assertEquals((int)-1, (int)((MetadataValue)entry.getValue()).getMaxIdle());
            }
        }
    }

    private Set<Integer> getKeysFromSegments(Set<Integer> segments) {
        RemoteCacheManager remoteCacheManager = (RemoteCacheManager)this.clients.get(0);
        RemoteCache cache = remoteCacheManager.getCache();
        Marshaller marshaller = ((RemoteCacheManager)this.clients.get(0)).getMarshaller();
        Function<byte[], Integer> segmentExtract = this.extractKeySegment(cache);
        CloseableIteratorSet keys = cache.keySet();
        return keys.stream().map(this::convertKey).filter(b -> segments.contains(segmentExtract.apply(Util.toByteBuffer(b, marshaller)))).collect(Collectors.toSet());
    }

    @AutoProtoSchemaBuilder(dependsOn={DslSCI.class}, includeClasses={ToHexConverterFactory.HexFilterConverter.class, SubstringFilterFactory.SubstringFilterConverter.class}, schemaFileName="test.client.BaseMultiServerRemoteIterator.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.client.BaseMultiServerRemoteIterator", service=false)
    static interface SCI
    extends SerializationContextInitializer {
        public static final SCI INSTANCE = new SCIImpl();
    }

    static final class SubstringFilterFactory
    implements ParamKeyValueFilterConverterFactory<String, String, String> {
        static final int DEFAULT_LENGTH = 20;

        SubstringFilterFactory() {
        }

        public KeyValueFilterConverter<String, String, String> getFilterConverter(Object[] params) {
            return new SubstringFilterConverter(params);
        }

        static class SubstringFilterConverter
        extends AbstractKeyValueFilterConverter<String, String, String> {
            @ProtoField(number=1, defaultValue="0")
            final int length;

            @ProtoFactory
            SubstringFilterConverter(int length) {
                this.length = length;
            }

            SubstringFilterConverter(Object[] params) {
                this.length = (Integer)(params == null || params.length == 0 ? Integer.valueOf(20) : params[0]);
            }

            public String filterAndConvert(String key, String value, Metadata metadata) {
                return value.substring(0, this.length);
            }
        }
    }

    static final class ToHexConverterFactory
    implements KeyValueFilterConverterFactory<Object, Object, String>,
    Serializable {
        ToHexConverterFactory() {
        }

        public KeyValueFilterConverter<Object, Object, String> getFilterConverter() {
            return new HexFilterConverter();
        }

        @ProtoName(value="HexFilterConverter")
        static class HexFilterConverter
        extends AbstractKeyValueFilterConverter<Object, Object, String> {
            HexFilterConverter() {
            }

            public String filterAndConvert(Object key, Object value, Metadata metadata) {
                return Integer.toHexString(Integer.parseInt(value.toString()));
            }
        }
    }
}

