/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.Arrays;
import java.util.Map;
import org.infinispan.client.hotrod.impl.iteration.BaseMultiServerRemoteIteratorTest;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.iteration.MediaTypeMultiServerRemoteIteratorTest")
public class MediaTypeMultiServerRemoteIteratorTest
extends BaseMultiServerRemoteIteratorTest {
    private static final int NUM_SERVERS = 3;
    private MediaType key = null;
    private MediaType value = null;

    private MediaTypeMultiServerRemoteIteratorTest withKeyType(MediaType key) {
        this.key = key;
        return this;
    }

    private MediaTypeMultiServerRemoteIteratorTest withValueType(MediaType value) {
        this.value = value;
        return this;
    }

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(3, this.getCacheConfiguration());
    }

    private ConfigurationBuilder getCacheConfiguration() {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)MediaTypeMultiServerRemoteIteratorTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        if (this.key != null) {
            builder.encoding().key().mediaType(this.key);
        }
        if (this.value != null) {
            builder.encoding().value().mediaType(this.value);
        }
        return builder;
    }

    @Override
    protected <T> Map.Entry<Object, T> convertEntry(Map.Entry<Object, ?> entry) {
        return super.convertEntry(Map.entry(Integer.valueOf(entry.getKey().toString()), entry.getValue()));
    }

    @Override
    protected <T> T convertKey(Object key) {
        return super.convertKey(Integer.valueOf(key.toString()));
    }

    public Object[] factory() {
        MediaType[] types = new MediaType[]{null, MediaType.APPLICATION_PROTOSTREAM, MediaType.TEXT_PLAIN, MediaType.APPLICATION_OBJECT};
        return Arrays.stream(types).flatMap(k -> Arrays.stream(types).map(v -> new MediaTypeMultiServerRemoteIteratorTest().withKeyType((MediaType)k).withValueType((MediaType)v))).toArray();
    }

    protected String parameters() {
        return String.format("[key=%s, value=%s]", this.key, this.value);
    }
}

