/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.impl.iteration.Util;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AccountPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.iteration.ProtobufRemoteIteratorIndexingTest")
public class ProtobufRemoteIteratorIndexingTest
extends MultiHotRodServersTest {
    private static final int NUM_NODES = 2;
    private static final int CACHE_SIZE = 10;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = ProtobufRemoteIteratorIndexingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        cfg.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("sample_bank_account.Account");
        this.createHotRodServers(2, HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)cfg));
        this.waitForClusterToForm();
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestDomainSCI.INSTANCE;
    }

    public void testSimpleIteration() {
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        Util.populateCache(10, Util::newAccountPB, cache);
        ArrayList results = new ArrayList();
        cache.retrieveEntries(null, null, 10).forEachRemaining(e -> results.add((AccountPB)e.getValue()));
        Assert.assertEquals((int)10, (int)results.size());
    }

    public void testFilteredIterationWithQuery() {
        RemoteCache remoteCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        Util.populateCache(10, Util::newAccountPB, remoteCache);
        QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)remoteCache);
        int lowerId = 5;
        int higherId = 8;
        Query simpleQuery = queryFactory.create("FROM sample_bank_account.Account WHERE id BETWEEN :lowerId AND :higherId").setParameter("lowerId", (Object)lowerId).setParameter("higherId", (Object)higherId);
        Set<Map.Entry<Object, Object>> entries = Util.extractEntries((CloseableIterator<Map.Entry<Object, Object>>)remoteCache.retrieveEntriesByQuery(simpleQuery, null, 10));
        Set keys = Util.extractKeys(entries);
        Assert.assertEquals((int)4, (int)keys.size());
        Util.assertForAll(keys, key -> key >= lowerId && key <= higherId);
        Util.assertForAll(entries, e -> e.getValue() instanceof AccountPB);
        Query projectionsQuery = queryFactory.create("SELECT id, description FROM sample_bank_account.Account WHERE id BETWEEN :lowerId AND :higherId").setParameter("lowerId", (Object)lowerId).setParameter("higherId", (Object)higherId);
        Set entriesWithProjection = Util.extractEntries((CloseableIterator<Map.Entry<Object, Object>>)remoteCache.retrieveEntriesByQuery(projectionsQuery, null, 10));
        Assert.assertEquals((int)4, (int)entriesWithProjection.size());
        Util.assertForAll(entriesWithProjection, entry -> {
            Integer id = (Integer)entry.getKey();
            Object[] projection = (Object[])entry.getValue();
            return projection[0].equals(id) && projection[1].equals("description for " + id);
        });
    }
}

