/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.iteration.DistFailOverRemoteIteratorTest;
import org.infinispan.client.hotrod.impl.iteration.Util;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.IntSets;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.iteration.SegmentFilteredFailOverTest")
public class SegmentFilteredFailOverTest
extends DistFailOverRemoteIteratorTest {
    static final int ENTRIES = 1000;

    @Override
    public void testFailOver() throws InterruptedException {
        RemoteCache remoteCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        Util.populateCache(1000, Util::newAccount, remoteCache);
        Cache cache = (Cache)this.caches().get(0);
        int totalSegments = cache.getCacheConfiguration().clustering().hash().numSegments();
        Set segments = IntStream.rangeClosed(0, totalSegments / 2).boxed().collect(Collectors.toSet());
        long expectedCount = cache.keySet().stream().filterKeySegments(IntSets.from(segments)).count();
        int actualCount = 0;
        try (CloseableIterator iterator = remoteCache.retrieveEntries(null, segments, 10);){
            for (int i = 0; i < 200; ++i) {
                iterator.next();
                ++actualCount;
            }
            this.killAnIterationServer();
            while (iterator.hasNext()) {
                iterator.next();
                ++actualCount;
            }
        }
        Assert.assertEquals((long)actualCount, (long)expectedCount);
    }
}

