/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.iteration.Util;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.embedded.DslSCI;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.AccountHS;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.iteration.SingleServerRemoteIteratorTest")
public class SingleServerRemoteIteratorTest
extends SingleHotRodServerTest {
    public static final String FILTER_CONVERTER_FACTORY_NAME = "even-accounts-descriptions";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)DslSCI.INSTANCE, (org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue()).addContextInitializer((SerializationContextInitializer)DslSCI.INSTANCE);
        return new InternalRemoteCacheManager(builder.build());
    }

    @Test
    public void testEmptyCache() {
        try (CloseableIterator iterator = this.remoteCacheManager.getCache().retrieveEntries(null, null, 100);){
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testEmptySegments() {
        Util.populateCache(1, i -> "value " + i, this.remoteCacheManager.getCache());
        try (CloseableIterator iterator = this.remoteCacheManager.getCache().retrieveEntries(null, Collections.emptySet(), 100);){
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN006016.*")
    public void testEmptyFilter() {
        try (CloseableIterator iterator = this.remoteCacheManager.getCache().retrieveEntries("", null, 100);){
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testException1() {
        try (CloseableIterator iterator = null;){
            iterator = this.remoteCacheManager.getCache().retrieveEntries(null, null, 100);
            iterator.next();
        }
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testException2() {
        Util.populateCache(3, i -> "value " + i, this.remoteCacheManager.getCache());
        CloseableIterator iterator = this.remoteCacheManager.getCache().retrieveEntries(null, null, 100);
        iterator.close();
        iterator.next();
    }

    public void testResultsSingleFetch() {
        RemoteCache cache = this.remoteCacheManager.getCache();
        Util.populateCache(3, i -> "value " + i, cache);
        HashSet<Map.Entry<Object, Object>> entries = new HashSet<Map.Entry<Object, Object>>();
        try (CloseableIterator iterator = cache.retrieveEntries(null, null, 5);){
            entries.add((Map.Entry)iterator.next());
            entries.add((Map.Entry)iterator.next());
            entries.add((Map.Entry)iterator.next());
        }
        Set keys = Util.extractKeys(entries);
        Set values = Util.extractValues(entries);
        AssertJUnit.assertEquals(keys, Util.setOf(0, 1, 2));
        AssertJUnit.assertEquals(values, Util.setOf("value 0", "value 1", "value 2"));
    }

    public void testResultsMultipleFetches() {
        RemoteCache cache = this.remoteCacheManager.getCache();
        int cacheSize = 100;
        Util.populateCache(cacheSize, i -> "value " + i, cache);
        HashSet<Map.Entry<Object, Object>> entries = new HashSet<Map.Entry<Object, Object>>();
        try (CloseableIterator iterator = cache.retrieveEntries(null, null, 5);){
            while (iterator.hasNext()) {
                entries.add((Map.Entry)iterator.next());
            }
        }
        Set keys = Util.extractKeys(entries);
        AssertJUnit.assertEquals(Util.rangeAsSet(0, cacheSize), keys);
    }

    public void testEntities() {
        RemoteCache cache = this.remoteCacheManager.getCache();
        int cacheSize = 50;
        Util.populateCache(cacheSize, Util::newAccount, cache);
        HashSet<Map.Entry<Object, Object>> entries = new HashSet<Map.Entry<Object, Object>>();
        try (CloseableIterator iterator = cache.retrieveEntries(null, null, 5);){
            while (iterator.hasNext()) {
                entries.add((Map.Entry)iterator.next());
            }
        }
        AssertJUnit.assertEquals((int)cacheSize, (int)entries.size());
        Set values = Util.extractValues(entries);
        Util.assertForAll(values, v -> v != null);
        Util.assertForAll(values, v -> v.getId() < cacheSize);
    }

    public void testFilterConverter() {
        this.hotrodServer.addKeyValueFilterConverterFactory(FILTER_CONVERTER_FACTORY_NAME, () -> new AbstractKeyValueFilterConverter<Integer, AccountHS, String>(){

            public String filterAndConvert(Integer key, AccountHS value, Metadata metadata) {
                if (key % 2 != 0) {
                    return null;
                }
                return value.getDescription();
            }
        });
        RemoteCache cache = this.remoteCacheManager.getCache();
        int cacheSize = 50;
        Util.populateCache(cacheSize, Util::newAccount, cache);
        HashSet<Map.Entry<Object, Object>> entries = new HashSet<Map.Entry<Object, Object>>();
        try (CloseableIterator iterator = cache.retrieveEntries(FILTER_CONVERTER_FACTORY_NAME, null, 5);){
            while (iterator.hasNext()) {
                entries.add((Map.Entry)iterator.next());
            }
        }
        AssertJUnit.assertEquals((int)(cacheSize / 2), (int)entries.size());
        Set keys = Util.extractKeys(entries);
        Util.assertForAll(keys, v -> v % 2 == 0);
    }
}

