/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.retry.AbstractRetryTest;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(groups={"functional"}, testName="client.hotrod.impl.transport.netty.ChannelPoolTest")
public class ChannelPoolTest
extends AbstractRetryTest {
    private int retries = 0;

    public ChannelPoolTest() {
    }

    public ChannelPoolTest(int nbrOfServers) {
        this.nbrOfServers = nbrOfServers;
    }

    @Override
    protected org.infinispan.configuration.cache.ConfigurationBuilder getCacheConfig() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)ChannelPoolTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.clustering().hash().numOwners(1);
        return builder;
    }

    @Override
    protected void amendRemoteCacheManagerConfiguration(ConfigurationBuilder builder) {
        builder.maxRetries(this.retries);
    }

    public void testClosingSockAndKillingServerFinishesOperations() throws Exception {
        this.doTest(true);
    }

    public void testClosingSockAndKeepingServerFinishesOperations() throws Exception {
        this.doTest(false);
    }

    private void doTest(boolean killServer) throws Exception {
        ChannelFactory channelFactory = this.remoteCacheManager.getChannelFactory();
        InetSocketAddress address = InetSocketAddress.createUnresolved(this.hotRodServer1.getHost(), this.hotRodServer1.getPort());
        AggregateCompletionStage pendingOperations = CompletionStages.aggregateCompletionStage();
        AtomicReference<Channel> channelRef = new AtomicReference<Channel>();
        CountDownLatch firstOp = new CountDownLatch(1);
        ExecutorService operationsExecutor = Executors.newFixedThreadPool(2);
        for (int i = 0; i < 10; ++i) {
            NoopRetryingOperation op = new NoopRetryingOperation(i, channelFactory, this.remoteCacheManager.getConfiguration(), channelRef, firstOp);
            operationsExecutor.submit(() -> (NoopRetryingOperation)channelFactory.fetchChannelAndInvoke((SocketAddress)address, (ChannelOperation)op));
            pendingOperations.dependsOn((CompletionStage)((Object)op));
        }
        ChannelPoolTest.eventually(() -> channelRef.get() != null);
        Channel channel = (Channel)channelRef.get();
        if (killServer) {
            HotRodClientTestingUtil.killServers(this.hotRodServer1);
        }
        channel.close().awaitUninterruptibly();
        firstOp.countDown();
        if (this.nbrOfServers == 1 && killServer) {
            this.assertConnectException((AggregateCompletionStage<Void>)pendingOperations);
            operationsExecutor.shutdown();
            return;
        }
        if (this.retries == 0 && killServer) {
            this.assertConnectException((AggregateCompletionStage<Void>)pendingOperations);
            operationsExecutor.shutdown();
            return;
        }
        pendingOperations.freeze().toCompletableFuture().get(10L, TimeUnit.SECONDS);
        operationsExecutor.shutdown();
    }

    private void assertConnectException(AggregateCompletionStage<Void> ops) {
        try {
            ops.freeze().toCompletableFuture().get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConnectException) {
                return;
            }
            throw new AssertionError("Expected ConnectException, but got " + String.valueOf(cause), cause);
        }
    }

    private ChannelPoolTest withRetries(int retries) {
        this.retries = retries;
        return this;
    }

    protected String parameters() {
        return "[retries=" + this.retries + ", nbrServers=" + this.nbrOfServers + "]";
    }

    public Object[] factory() {
        return new Object[]{new ChannelPoolTest().withRetries(0), new ChannelPoolTest(1).withRetries(0), new ChannelPoolTest().withRetries(10), new ChannelPoolTest(1).withRetries(10)};
    }

    private static class NoopRetryingOperation
    extends RetryOnFailureOperation<Void> {
        private final AtomicReference<Channel> channelRef;
        private final CountDownLatch firstOp;
        private final int id;

        protected NoopRetryingOperation(int nbr, ChannelFactory channelFactory, Configuration cfg, AtomicReference<Channel> channelRef, CountDownLatch firstOp) {
            super((short)0, (short)0, null, channelFactory, null, new AtomicReference<ClientTopology>(new ClientTopology(-1, cfg.clientIntelligence())), 0, cfg, DataFormat.builder().build(), null);
            this.channelRef = channelRef;
            this.firstOp = firstOp;
            this.id = nbr;
        }

        public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
            this.complete(null);
        }

        protected void executeOperation(Channel channel) {
            if (this.channelRef.compareAndSet(null, channel)) {
                try {
                    this.firstOp.await();
                    this.complete(null);
                }
                catch (InterruptedException e) {
                    this.completeExceptionally(e);
                }
            } else {
                this.complete(null);
            }
        }

        public String toString() {
            return "id = " + this.id;
        }
    }
}

