/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.retry.AbstractRetryTest;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(testName="client.hotrod.impl.transport.netty.CrashMidOperationTest", groups={"functional"})
public class CrashMidOperationTest
extends AbstractRetryTest {
    @Override
    protected org.infinispan.configuration.cache.ConfigurationBuilder getCacheConfig() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)CrashMidOperationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.clustering().hash().numOwners(1);
        return builder;
    }

    @Override
    protected void amendRemoteCacheManagerConfiguration(ConfigurationBuilder builder) {
        builder.maxRetries(0);
    }

    public void killServerMidOperation() throws Exception {
        ChannelFactory channelFactory = this.remoteCacheManager.getChannelFactory();
        InetSocketAddress address = InetSocketAddress.createUnresolved(this.hotRodServer1.getHost(), this.hotRodServer1.getPort());
        CountDownLatch operationLatch = new CountDownLatch(1);
        AtomicReference<Channel> channelRef = new AtomicReference<Channel>();
        NoopRetryingOperation firstOperation = new NoopRetryingOperation(0, channelFactory, this.remoteCacheManager.getConfiguration(), channelRef, operationLatch);
        this.fork(() -> (NoopRetryingOperation)channelFactory.fetchChannelAndInvoke((SocketAddress)address, (ChannelOperation)firstOperation));
        CrashMidOperationTest.eventually(() -> channelRef.get() != null);
        Channel channel = channelRef.get();
        HotRodClientTestingUtil.killServers(this.hotRodServer1);
        CrashMidOperationTest.eventually(() -> !channel.isActive());
        CrashMidOperationTest.eventually(() -> firstOperation.isDone());
        Exceptions.expectExecutionException(TransportException.class, (Future)((Object)firstOperation));
        NoopRetryingOperation secondOperation = new NoopRetryingOperation(1, channelFactory, this.remoteCacheManager.getConfiguration(), channelRef, operationLatch);
        channelFactory.fetchChannelAndInvoke((SocketAddress)address, this.remoteCache.getName().getBytes(StandardCharsets.UTF_8), (ChannelOperation)secondOperation);
        CrashMidOperationTest.eventually(() -> secondOperation.isDone());
        Assertions.assertThatThrownBy(() -> secondOperation.get(10L, TimeUnit.SECONDS)).cause().isInstanceOf(ConnectException.class);
        operationLatch.countDown();
        NoopRetryingOperation thirdOperation = new NoopRetryingOperation(2, channelFactory, this.remoteCacheManager.getConfiguration(), channelRef, operationLatch);
        channelFactory.fetchChannelAndInvoke((SocketAddress)address, this.remoteCache.getName().getBytes(StandardCharsets.UTF_8), (ChannelOperation)thirdOperation);
        CrashMidOperationTest.eventually(() -> thirdOperation.isDone());
        thirdOperation.get(10L, TimeUnit.SECONDS);
    }

    static class NoopRetryingOperation
    extends RetryOnFailureOperation<Void> {
        private final AtomicReference<Channel> channelRef;
        private final CountDownLatch firstOp;
        private final int id;

        protected NoopRetryingOperation(int nbr, ChannelFactory channelFactory, Configuration cfg, AtomicReference<Channel> channelRef, CountDownLatch firstOp) {
            super((short)0, (short)0, null, channelFactory, null, new AtomicReference<ClientTopology>(new ClientTopology(-1, cfg.clientIntelligence())), 0, cfg, DataFormat.builder().build(), null);
            this.channelRef = channelRef;
            this.firstOp = firstOp;
            this.id = nbr;
        }

        public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
            this.complete(null);
        }

        protected void executeOperation(Channel channel) {
            if (this.channelRef.compareAndSet(null, channel)) {
                try {
                    this.scheduleRead(channel);
                    this.firstOp.await();
                }
                catch (InterruptedException e) {
                    this.completeExceptionally(e);
                }
                assert (this.isDone()) : "Should be done";
                return;
            }
            this.complete(null);
        }

        public String toString() {
            return "id = " + this.id;
        }
    }
}

