/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.util.Date;
import java.util.List;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.marshall.EmbeddedRemoteInteropQueryTest;
import org.infinispan.commons.api.query.Query;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.TransactionHS;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.marshall.NonIndexedEmbeddedRemoteQueryTest", groups={"functional"})
@CleanupAfterMethod
public class NonIndexedEmbeddedRemoteQueryTest
extends EmbeddedRemoteInteropQueryTest {
    @Override
    protected ConfigurationBuilder createConfigBuilder() {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.encoding().key().mediaType("application/x-java-object");
        builder.encoding().value().mediaType("application/x-java-object");
        return builder;
    }

    @Override
    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN028521: Full-text queries cannot be applied to property 'longDescription' in type sample_bank_account.Transaction unless the property is indexed and analyzed.")
    public void testRemoteFullTextQuery() {
        TransactionHS transaction = new TransactionHS();
        transaction.setId(3);
        transaction.setDescription("Hotel");
        transaction.setLongDescription("Expenses for Infinispan F2F meeting");
        transaction.setAccountId(2);
        transaction.setAmount(99.0);
        transaction.setDate(new Date(42L));
        transaction.setDebit(true);
        transaction.setValid(true);
        this.cache.put((Object)transaction.getId(), (Object)transaction);
        Query q = this.remoteCache.query("from sample_bank_account.Transaction where longDescription:'Expenses for Infinispan F2F meeting'");
        List list = q.execute().list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
    }
}

