/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshallerWithAnnotationsTestSCIImpl;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.marshall.ProtoStreamMarshallerWithAnnotationsTest", groups={"functional"})
@CleanupAfterMethod
public class ProtoStreamMarshallerWithAnnotationsTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Integer, AnnotatedUser> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cache = this.cacheManager.getCache().getAdvancedCache().withStorageMediaType();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        HotRodClientTestingUtil.registerSCI(this.remoteCacheManager, ProtoStreamMarshallerWithAnnotationsTestSCI.INSTANCE);
        return this.cacheManager;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)this.remoteCacheManager);
        this.remoteCacheManager = null;
        HotRodClientTestingUtil.killServers(this.hotRodServer);
        this.hotRodServer = null;
    }

    public void testPutAndGet() throws Exception {
        AnnotatedUser user = this.createUser();
        this.remoteCache.put((Object)1, (Object)user);
        AssertJUnit.assertEquals((int)1, (int)this.cache.keySet().size());
        byte[] key = (byte[])this.cache.keySet().iterator().next();
        Object localObject = this.cache.get((Object)key);
        AssertJUnit.assertNotNull((Object)localObject);
        AssertJUnit.assertTrue((boolean)(localObject instanceof byte[]));
        Object unmarshalledObject = ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)MarshallerUtil.getSerializationContext((RemoteCacheContainer)this.remoteCacheManager), (byte[])((byte[])localObject));
        AssertJUnit.assertTrue((boolean)(unmarshalledObject instanceof AnnotatedUser));
        this.assertUser((AnnotatedUser)unmarshalledObject);
        AnnotatedUser fromRemoteCache = (AnnotatedUser)this.remoteCache.get((Object)1);
        this.assertUser(fromRemoteCache);
    }

    private AnnotatedUser createUser() {
        AnnotatedUser user = new AnnotatedUser();
        user.setId(33);
        user.setName("Tom");
        return user;
    }

    private void assertUser(AnnotatedUser user) {
        AssertJUnit.assertNotNull((Object)user);
        AssertJUnit.assertEquals((int)33, (int)user.getId());
        AssertJUnit.assertEquals((String)"Tom", (String)user.getName());
    }

    @AutoProtoSchemaBuilder(includeClasses={AnnotatedUser.class}, schemaFileName="test.client.ProtoStreamMarshallerWithAnnotationsTest.proto", schemaFilePath="proto/generated", service=false)
    public static interface ProtoStreamMarshallerWithAnnotationsTestSCI
    extends GeneratedSchema {
        public static final GeneratedSchema INSTANCE = new ProtoStreamMarshallerWithAnnotationsTestSCIImpl();
    }

    @ProtoName(value="User")
    public static class AnnotatedUser {
        private int id;
        private String name;

        @ProtoField(number=1, defaultValue="0")
        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @ProtoField(value=2)
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "AnnotatedUser{id=" + this.id + ", name='" + this.name + "'}";
        }
    }
}

