/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall.protostream.validation;

import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.protostream.impl.ResourceUtils;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.marshall.protostream.validation.ProtobufValidationTest")
public class ProtobufValidationTest
extends SingleHotRodServerTest {
    private static final String SCHEMA_NAME = "my-schema.proto";
    public static final String SCHEMA_ERROR_KEY = "my-schema.proto.errors";
    private Cache<String, String> metadataCache;
    private String goodSchema;
    private String wrongSchema;

    @BeforeClass
    public void beforeAll() {
        this.metadataCache = this.cacheManager.getCache("___protobuf_metadata");
        this.goodSchema = ResourceUtils.getResourceAsString(((Object)((Object)this)).getClass(), (String)"/proto/ciao.proto");
        this.wrongSchema = ResourceUtils.getResourceAsString(((Object)((Object)this)).getClass(), (String)"/proto/ciao-wrong.proto");
    }

    @AfterMethod
    public void afterEach() {
        this.metadataCache.clear();
    }

    @Test
    public void testGoodSchema() {
        this.metadataCache.put((Object)SCHEMA_NAME, (Object)this.goodSchema);
        String filesWithErrors = (String)this.metadataCache.get((Object)".errors");
        Assertions.assertThat((String)filesWithErrors).isNull();
    }

    @Test
    public void testWrongSchema() {
        this.metadataCache.put((Object)SCHEMA_NAME, (Object)this.wrongSchema);
        String filesWithErrors = (String)this.metadataCache.get((Object)".errors");
        Assertions.assertThat((String)filesWithErrors).isEqualTo(SCHEMA_NAME);
        String errorMessage = (String)this.metadataCache.get((Object)SCHEMA_ERROR_KEY);
        Assertions.assertThat((String)errorMessage).isNotBlank();
    }

    @Test
    public void testUpdateWithWrongSchema() {
        this.metadataCache.put((Object)SCHEMA_NAME, (Object)this.goodSchema);
        String filesWithErrors = (String)this.metadataCache.get((Object)".errors");
        Assertions.assertThat((String)filesWithErrors).isNull();
        this.metadataCache.put((Object)SCHEMA_NAME, (Object)this.wrongSchema);
        filesWithErrors = (String)this.metadataCache.get((Object)".errors");
        Assertions.assertThat((String)filesWithErrors).isEqualTo(SCHEMA_NAME);
        String errorMessage = (String)this.metadataCache.get((Object)SCHEMA_ERROR_KEY);
        Assertions.assertThat((String)errorMessage).isNotBlank();
    }
}

