/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.multimap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.multimap.MultimapCacheManager;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCache;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCacheManagerFactory;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.HotRodServer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.multimap.RemoteMultimapStateTransferTest")
public class RemoteMultimapStateTransferTest
extends MultiHotRodServersTest {
    private static final int NODES = 2;
    private static final int VALUES = 4;
    private static final String CACHE_NAME = "multimap";
    private ClientIntelligence clientIntelligence;

    public RemoteMultimapStateTransferTest clientIntelligence(ClientIntelligence clientIntelligence) {
        this.clientIntelligence = clientIntelligence;
        return this;
    }

    public Object[] factory() {
        return Arrays.stream(ClientIntelligence.values()).flatMap(ci -> Stream.of(CacheMode.DIST_SYNC, CacheMode.DIST_ASYNC).map(cm -> new RemoteMultimapStateTransferTest().clientIntelligence((ClientIntelligence)ci).cacheMode((CacheMode)cm))).toArray();
    }

    protected Object[] parameterValues() {
        return RemoteMultimapStateTransferTest.concat((Object[])super.parameterValues(), (Object[])new Object[]{this.clientIntelligence});
    }

    protected String[] parameterNames() {
        return (String[])RemoteMultimapStateTransferTest.concat((Object[])super.parameterNames(), (Object[])new String[]{"clientIntelligence"});
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cacheBuilder = RemoteMultimapStateTransferTest.getDefaultClusteredCacheConfig((CacheMode)this.cacheMode, (boolean)false);
        cacheBuilder.statistics().enable();
        this.createHotRodServers(2, new org.infinispan.configuration.cache.ConfigurationBuilder());
        this.defineInAll(CACHE_NAME, cacheBuilder);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder cb = super.createHotRodClientConfigurationBuilder(host, serverPort);
        cb.clientIntelligence(this.clientIntelligence);
        return cb;
    }

    public void testStateTransfer() {
        RemoteMultimapCache<String, String> mc = this.multimapCache(0);
        List<String> values1 = RemoteMultimapStateTransferTest.createValues();
        String key1 = Util.threadLocalRandomUUID().toString();
        RemoteMultimapStateTransferTest.storeValues(mc, key1, values1);
        List<String> values2 = RemoteMultimapStateTransferTest.createValues();
        String key2 = Util.threadLocalRandomUUID().toString();
        RemoteMultimapStateTransferTest.storeValues(mc, key2, values2);
        for (int i = 0; i < 2; ++i) {
            this.assertData(i, key1, values1);
            this.assertData(i, key2, values2);
        }
        HotRodServer server = this.addHotRodServerAndClient(new org.infinispan.configuration.cache.ConfigurationBuilder());
        this.defineCache(server, CACHE_NAME, RemoteMultimapStateTransferTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        for (int i = 0; i < 3; ++i) {
            this.assertData(i, key1, values1);
            this.assertData(i, key2, values2);
        }
    }

    private RemoteMultimapCache<String, String> multimapCache(int index) {
        MultimapCacheManager mcm = RemoteMultimapCacheManagerFactory.from((RemoteCacheManager)this.client(index));
        return mcm.get(CACHE_NAME);
    }

    private void assertData(int index, String key, List<String> values) {
        RemoteMultimapCache<String, String> mc = this.multimapCache(index);
        Collection data = (Collection)mc.get((Object)key).join();
        AssertJUnit.assertEquals((int)values.size(), (int)data.size());
        for (String v : values) {
            AssertJUnit.assertTrue((boolean)data.contains(v));
        }
    }

    private static void storeValues(RemoteMultimapCache<String, String> rmc, String key, List<String> values) {
        for (String v : values) {
            rmc.put((Object)key, (Object)v).join();
        }
    }

    private static List<String> createValues() {
        ArrayList<String> values = new ArrayList<String>(4);
        for (int i = 0; i < 4; ++i) {
            values.add(Util.threadLocalRandomUUID().toString());
        }
        return values;
    }
}

