/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClusteredListenerMarshallerTest")
public class ClusterNearCacheMarshallingTest
extends MultiHotRodServersTest {
    private static final String SERVER_DEFINED_CACHE = "other-cache";
    private Class<? extends Marshaller> marshaller;
    private MediaType storeType;
    private boolean bloomFilter;

    public ClusterNearCacheMarshallingTest() {
    }

    protected ClusterNearCacheMarshallingTest(Class<? extends Marshaller> marshaller, MediaType storeType, boolean bloomFilter) {
        this.marshaller = marshaller;
        this.storeType = storeType;
        this.bloomFilter = bloomFilter;
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder serverCfg = ClusterNearCacheMarshallingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        if (this.storeType != null) {
            HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)serverCfg, (MediaType)this.storeType);
        }
        this.createHotRodServers(2, serverCfg);
        this.waitForClusterToForm();
        org.infinispan.configuration.cache.ConfigurationBuilder cb = new org.infinispan.configuration.cache.ConfigurationBuilder();
        cb.encoding().key().mediaType("application/octet-stream");
        cb.encoding().value().mediaType("application/octet-stream");
        TestingUtil.defineConfiguration((EmbeddedCacheManager)this.manager(0), (String)SERVER_DEFINED_CACHE, (Configuration)cb.build());
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder cb = super.createHotRodClientConfigurationBuilder(host, serverPort);
        if (this.marshaller != null) {
            cb.marshaller(this.marshaller);
        }
        cb.nearCache().mode(NearCacheMode.INVALIDATED).maxEntries(100);
        cb.remoteCache("").nearCacheMode(NearCacheMode.INVALIDATED).nearCacheMaxEntries(2).nearCacheUseBloomFilter(this.bloomFilter);
        cb.connectionPool().maxActive(1);
        return cb;
    }

    public void testServerDefinedCache() {
        RemoteCacheManager cacheManager = this.client(0);
        Assertions.assertThat((Map)cacheManager.getCache(SERVER_DEFINED_CACHE)).isNotNull();
        Assertions.assertThat((Map)cacheManager.getCache()).isNotNull();
    }

    public void testRemoteWriteOnLocal() {
        RemoteCacheManager cacheManager = this.client(0);
        RemoteCacheManager cacheManager1 = this.client(1);
        RemoteCache cache = cacheManager.getCache();
        cache.put((Object)"K", (Object)"V");
        Assertions.assertThat((String)((String)cache.get((Object)"K"))).isEqualTo("V");
        RemoteCache cache1 = cacheManager1.getCache();
        Assertions.assertThat((String)((String)cache1.get((Object)"K"))).isEqualTo("V");
        cache1.replace((Object)"K", (Object)"V1");
        Assertions.assertThat((String)((String)cache1.get((Object)"K"))).isEqualTo("V1");
        ClusterNearCacheMarshallingTest.eventually(() -> ((String)cache.get((Object)"K")).equals("V1"));
    }

    public Object[] factory() {
        return Stream.of(true, false).flatMap(bloomFilter -> Stream.of(new ClusterNearCacheMarshallingTest(null, null, (boolean)bloomFilter), new ClusterNearCacheMarshallingTest((Class<? extends Marshaller>)GenericJBossMarshaller.class, MediaType.APPLICATION_JBOSS_MARSHALLING, (boolean)bloomFilter), new ClusterNearCacheMarshallingTest((Class<? extends Marshaller>)ProtoStreamMarshaller.class, MediaType.APPLICATION_PROTOSTREAM, (boolean)bloomFilter), new ClusterNearCacheMarshallingTest((Class<? extends Marshaller>)ProtoStreamMarshaller.class, null, (boolean)bloomFilter), new ClusterNearCacheMarshallingTest((Class<? extends Marshaller>)GenericJBossMarshaller.class, null, (boolean)bloomFilter), new ClusterNearCacheMarshallingTest((Class<? extends Marshaller>)JavaSerializationMarshaller.class, null, (boolean)bloomFilter))).toArray();
    }

    protected String parameters() {
        return String.format("(marshaller=%s, mediaType=%s, bloomFilter=%b", this.marshaller != null ? this.marshaller.getSimpleName() : "null", this.storeType, this.bloomFilter);
    }
}

